/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.schema;

import com.lancedb.lance.schema.StorageType;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;

public class LanceField {
    private final int id;
    private final int parentId;
    private final String name;
    private final boolean nullable;
    private final ArrowType type;
    private final StorageType storageType;
    private final DictionaryEncoding dictionaryEncoding;
    private final Map<String, String> metadata;
    private final List<LanceField> children;
    private final boolean isUnenforcedPrimaryKey;

    LanceField(int id, int parentId, String name, boolean nullable, ArrowType type, StorageType storageType, DictionaryEncoding dictionaryEncoding, Map<String, String> metadata, List<LanceField> children, boolean isUnenforcedPrimaryKey) {
        this.id = id;
        this.parentId = parentId;
        this.name = name;
        this.nullable = nullable;
        this.type = type;
        this.storageType = storageType;
        this.dictionaryEncoding = dictionaryEncoding;
        this.metadata = metadata;
        this.children = children;
        this.isUnenforcedPrimaryKey = isUnenforcedPrimaryKey;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ArrowType getType() {
        return this.type;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public Optional<DictionaryEncoding> getDictionaryEncoding() {
        return Optional.ofNullable(this.dictionaryEncoding);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<LanceField> getChildren() {
        return this.children;
    }

    public boolean isUnenforcedPrimaryKey() {
        return this.isUnenforcedPrimaryKey;
    }

    public Field asArrowField() {
        List arrowChildren = this.children.stream().map(LanceField::asArrowField).collect(Collectors.toList());
        return new Field(this.name, new FieldType(this.nullable, this.type, this.dictionaryEncoding, this.metadata), arrowChildren);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("parentId", this.parentId).add("name", this.name).add("nullable", this.nullable).add("type", this.type).add("storageType", (Object)this.storageType).add("dictionaryEncoding", this.dictionaryEncoding).add("children", this.children).add("isUnenforcedPrimaryKey", this.isUnenforcedPrimaryKey).add("metadata", this.metadata).toString();
    }
}

