/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.shaded.guava.util.concurrent;

import com.lancedb.lance.shaded.guava.annotations.GwtCompatible;
import com.lancedb.lance.shaded.guava.base.Preconditions;
import com.lancedb.lance.shaded.guava.util.concurrent.ElementTypesAreNonnullByDefault;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

