/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.FilesetVersionPO;
import org.apache.ibatis.annotations.Param;

public class FilesetVersionBaseSQLProvider {
    public String insertFilesetVersions(@Param(value="filesetVersions") List<FilesetVersionPO> filesetVersionPOs) {
        return "<script>INSERT INTO fileset_version_info (metalake_id, catalog_id, schema_id, fileset_id, version, fileset_comment, properties, storage_location_name, storage_location, deleted_at) VALUES <foreach collection='filesetVersions' item='version' separator=','> (#{version.metalakeId}, #{version.catalogId}, #{version.schemaId}, #{version.filesetId}, #{version.version}, #{version.filesetComment}, #{version.properties}, #{version.locationName}, #{version.storageLocation}, #{version.deletedAt})</foreach></script>";
    }

    public String insertFilesetVersionsOnDuplicateKeyUpdate(@Param(value="filesetVersions") List<FilesetVersionPO> filesetVersionPOs) {
        return "<script>INSERT INTO fileset_version_info (metalake_id, catalog_id, schema_id, fileset_id, version, fileset_comment, properties, storage_location_name, storage_location, deleted_at) VALUES <foreach collection='filesetVersions' item='version' separator=','> (#{version.metalakeId}, #{version.catalogId}, #{version.schemaId}, #{version.filesetId}, #{version.version}, #{version.filesetComment}, #{version.properties}, #{version.locationName}, #{version.storageLocation}, #{version.deletedAt})</foreach> ON DUPLICATE KEY UPDATE metalake_id = VALUES(metalake_id), catalog_id = VALUES(catalog_id), schema_id = VALUES(schema_id), fileset_id = VALUES(fileset_id), version = VALUES(version), fileset_comment = VALUES(fileset_comment), properties = VALUES(properties), storage_location_name = VALUES(storage_location_name), storage_location = VALUES(storage_location), deleted_at = VALUES(deleted_at)</script>";
    }

    public String softDeleteFilesetVersionsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String softDeleteFilesetVersionsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    public String softDeleteFilesetVersionsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    public String softDeleteFilesetVersionsByFilesetId(@Param(value="filesetId") Long filesetId) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE fileset_id = #{filesetId} AND deleted_at = 0";
    }

    public String deleteFilesetVersionsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM fileset_version_info WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    public String selectFilesetVersionsByRetentionCount(@Param(value="versionRetentionCount") Long versionRetentionCount) {
        return "SELECT fileset_id as filesetId, MAX(version) as version FROM fileset_version_info WHERE version > #{versionRetentionCount} AND deleted_at = 0 GROUP BY fileset_id";
    }

    public String softDeleteFilesetVersionsByRetentionLine(@Param(value="filesetId") Long filesetId, @Param(value="versionRetentionLine") long versionRetentionLine, @Param(value="limit") int limit) {
        return "UPDATE fileset_version_info SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE fileset_id = #{filesetId} AND version <= #{versionRetentionLine} AND deleted_at = 0 LIMIT #{limit}";
    }
}

