/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.oss.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.SupportsCredentialVending;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.OSSSecretKeyCredential;
import org.apache.gravitino.credential.OSSTokenCredential;
import org.apache.gravitino.oss.fs.OSSCredentialsProvider;
import org.apache.gravitino.oss.fs.OSSUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;

public class OSSFileSystemProvider
implements FileSystemProvider,
SupportsCredentialVending {
    private static final String OSS_FILESYSTEM_IMPL = "fs.oss.impl";
    @VisibleForTesting
    public static final Map<String, String> GRAVITINO_KEY_TO_OSS_HADOOP_KEY = ImmutableMap.of((Object)"oss-endpoint", (Object)"fs.oss.endpoint", (Object)"oss-access-key-id", (Object)"fs.oss.accessKeyId", (Object)"oss-secret-access-key", (Object)"fs.oss.accessKeySecret");

    public FileSystem getFileSystem(Path path, Map<String, String> config) throws IOException {
        Map<String, String> hadoopConfMap = FileSystemUtils.toHadoopConfigMap(config, GRAVITINO_KEY_TO_OSS_HADOOP_KEY);
        if (!hadoopConfMap.containsKey(OSS_FILESYSTEM_IMPL)) {
            hadoopConfMap.put(OSS_FILESYSTEM_IMPL, AliyunOSSFileSystem.class.getCanonicalName());
        }
        hadoopConfMap = this.additionalOSSConfig(hadoopConfMap);
        Configuration configuration = FileSystemUtils.createConfiguration(hadoopConfMap);
        return AliyunOSSFileSystem.newInstance((URI)path.toUri(), (Configuration)configuration);
    }

    public Map<String, String> getFileSystemCredentialConf(Credential[] credentials) {
        Credential credential = OSSUtils.getSuitableCredential(credentials);
        HashMap result = Maps.newHashMap();
        if (credential instanceof OSSSecretKeyCredential || credential instanceof OSSTokenCredential) {
            result.put("fs.oss.credentials.provider", OSSCredentialsProvider.class.getCanonicalName());
        }
        return result;
    }

    public String scheme() {
        return "oss";
    }

    public String name() {
        return "oss";
    }

    private Map<String, String> additionalOSSConfig(Map<String, String> configs) {
        HashMap additionalConfigs = Maps.newHashMap(configs);
        if (!configs.containsKey("fs.oss.connection.establish.timeout")) {
            additionalConfigs.put("fs.oss.connection.establish.timeout", "5000");
        }
        if (!configs.containsKey("fs.oss.attempts.maximum")) {
            additionalConfigs.put("fs.oss.attempts.maximum", "2");
        }
        return ImmutableMap.copyOf((Map)additionalConfigs);
    }
}

