/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.factory.map.primitive.ImmutableFloatObjectMapFactory;
import org.eclipse.collections.api.map.primitive.FloatObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatObjectMap;
import org.eclipse.collections.api.map.primitive.MutableFloatObjectMap;
import org.eclipse.collections.impl.factory.primitive.FloatObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableFloatObjectSingletonMap;

public class ImmutableFloatObjectMapFactoryImpl
implements ImmutableFloatObjectMapFactory {
    public static final ImmutableFloatObjectMapFactory INSTANCE = new ImmutableFloatObjectMapFactoryImpl();

    public <V> ImmutableFloatObjectMap<V> empty() {
        return ImmutableFloatObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableFloatObjectMap<V> of() {
        return this.empty();
    }

    public <V> ImmutableFloatObjectMap<V> with() {
        return this.empty();
    }

    public <V> ImmutableFloatObjectMap<V> of(float key, V value) {
        return this.with(key, value);
    }

    public <V> ImmutableFloatObjectMap<V> with(float key, V value) {
        return new ImmutableFloatObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableFloatObjectMap<V> ofAll(FloatObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    public <V> ImmutableFloatObjectMap<V> withAll(FloatObjectMap<? extends V> map) {
        if (map instanceof ImmutableFloatObjectMap) {
            return (ImmutableFloatObjectMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            float[] array = new float[1];
            map.forEachKey((FloatProcedure & Serializable)each -> {
                array[0] = each;
            });
            return new ImmutableFloatObjectSingletonMap<Object>(array[0], map.get(array[0]));
        }
        return new ImmutableFloatObjectHashMap<V>(map);
    }

    public <T, V> ImmutableFloatObjectMap<V> from(Iterable<T> iterable, FloatFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableFloatObjectMap map = FloatObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map.toImmutable();
    }
}

