/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.NamespacedEntityId;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.StatisticMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TableVersionMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.TableColumnMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class TableMetaService {
    private static final TableMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;

    public static TableMetaService getInstance() {
        return INSTANCE;
    }

    private TableMetaService() {
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getTableIdBySchemaIdAndName")
    public Long getTableIdBySchemaIdAndName(Long schemaId, String tableName) {
        Long l = schemaId;
        String string = tableName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TableMetaService.class.getDeclaredMethod("getTableIdBySchemaIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)TableMetaService.getTableIdBySchemaIdAndName_aroundBody1$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getTableByIdentifier")
    public TableEntity getTableByIdentifier(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TableMetaService.class.getDeclaredMethod("getTableByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (TableEntity)TableMetaService.getTableByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listTablesByNamespace")
    public List<TableEntity> listTablesByNamespace(Namespace namespace) {
        Namespace namespace2 = namespace;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)namespace2);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TableMetaService.class.getDeclaredMethod("listTablesByNamespace", Namespace.class).getAnnotation(Monitored.class);
        }
        return (List)TableMetaService.listTablesByNamespace_aroundBody5$advice(this, namespace2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertTable")
    public void insertTable(TableEntity tableEntity, boolean overwrite) throws IOException {
        TableEntity tableEntity2 = tableEntity;
        boolean bl = overwrite;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)tableEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TableMetaService.class.getDeclaredMethod("insertTable", TableEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        TableMetaService.insertTable_aroundBody7$advice(this, tableEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateTable")
    public <E extends Entity & HasIdentifier> TableEntity updateTable(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TableMetaService.class.getDeclaredMethod("updateTable", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (TableEntity)TableMetaService.updateTable_aroundBody9$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteTable")
    public boolean deleteTable(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TableMetaService.class.getDeclaredMethod("deleteTable", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)TableMetaService.deleteTable_aroundBody11$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteTableMetasByLegacyTimeline")
    public int deleteTableMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TableMetaService.class.getDeclaredMethod("deleteTableMetasByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)TableMetaService.deleteTableMetasByLegacyTimeline_aroundBody13$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteTableVersionByLegacyTimeline")
    public int deleteTableVersionByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = TableMetaService.class.getDeclaredMethod("deleteTableVersionByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)TableMetaService.deleteTableVersionByLegacyTimeline_aroundBody15$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private void fillTablePOBuilderParentEntityId(TablePO.Builder builder, Namespace namespace) {
        NamespaceUtil.checkTable(namespace);
        NamespacedEntityId namespacedEntityId = EntityIdService.getEntityIds(NameIdentifier.of((String[])namespace.levels()), Entity.EntityType.SCHEMA);
        builder.withMetalakeId(namespacedEntityId.namespaceIds()[0]);
        builder.withCatalogId(namespacedEntityId.namespaceIds()[1]);
        builder.withSchemaId(namespacedEntityId.entityId());
    }

    private TablePO getTablePOBySchemaIdAndName(Long schemaId, String tableName) {
        TablePO tablePO = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.selectTableMetaBySchemaIdAndName(schemaId, tableName));
        if (tablePO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TABLE.name().toLowerCase(), tableName});
        }
        return tablePO;
    }

    static {
        TableMetaService.ajc$preClinit();
        INSTANCE = new TableMetaService();
    }

    private static final /* synthetic */ Long getTableIdBySchemaIdAndName_aroundBody0(TableMetaService ajc$this, Long schemaId, String tableName, JoinPoint joinPoint) {
        Long tableId = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.selectTableIdBySchemaIdAndName(schemaId, tableName));
        if (tableId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.TABLE.name().toLowerCase(), tableName});
        }
        return tableId;
    }

    private static final /* synthetic */ Object getTableIdBySchemaIdAndName_aroundBody1$advice(TableMetaService ajc$this, Long schemaId, String tableName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.getTableIdBySchemaIdAndName_aroundBody0(ajc$this, schemaId, tableName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.getTableIdBySchemaIdAndName_aroundBody0(ajc$this, schemaId, tableName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = TableMetaService.getTableIdBySchemaIdAndName_aroundBody0(ajc$this, schemaId, tableName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ TableEntity getTableByIdentifier_aroundBody2(TableMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        NameIdentifierUtil.checkTable(identifier);
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])identifier.namespace().levels()), Entity.EntityType.SCHEMA);
        TablePO tablePO = ajc$this.getTablePOBySchemaIdAndName(schemaId, identifier.name());
        List<ColumnPO> columnPOs = TableColumnMetaService.getInstance().getColumnsByTableIdAndVersion(tablePO.getTableId(), tablePO.getCurrentVersion());
        return POConverters.fromTableAndColumnPOs(tablePO, columnPOs, identifier.namespace());
    }

    private static final /* synthetic */ Object getTableByIdentifier_aroundBody3$advice(TableMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        TableEntity tableEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.getTableByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.getTableByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableEntity result = TableMetaService.getTableByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                tableEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return tableEntity;
    }

    private static final /* synthetic */ List listTablesByNamespace_aroundBody4(TableMetaService ajc$this, Namespace namespace, JoinPoint joinPoint) {
        NamespaceUtil.checkTable(namespace);
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])namespace.levels()), Entity.EntityType.SCHEMA);
        List tablePOs = SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.listTablePOsBySchemaId(schemaId));
        return POConverters.fromTablePOs(tablePOs, namespace);
    }

    private static final /* synthetic */ Object listTablesByNamespace_aroundBody5$advice(TableMetaService ajc$this, Namespace namespace, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.listTablesByNamespace_aroundBody4(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.listTablesByNamespace_aroundBody4(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = TableMetaService.listTablesByNamespace_aroundBody4(ajc$this, namespace, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ void insertTable_aroundBody6(TableMetaService ajc$this, TableEntity tableEntity, boolean overwrite, JoinPoint joinPoint) {
        try {
            NameIdentifierUtil.checkTable(tableEntity.nameIdentifier());
            TablePO.Builder builder = TablePO.builder();
            ajc$this.fillTablePOBuilderParentEntityId(builder, tableEntity.namespace());
            AtomicReference tablePORef = new AtomicReference();
            TablePO po = POConverters.initializeTablePOWithVersion(tableEntity, builder);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(TableMetaMapper.class, mapper -> {
                tablePORef.set(po);
                if (overwrite) {
                    mapper.insertTableMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertTableMeta(po);
                }
            }), () -> SessionUtils.doWithoutCommit(TableVersionMapper.class, mapper -> {
                if (overwrite) {
                    mapper.insertTableVersionOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertTableVersion(po);
                }
            }), () -> {
                if (overwrite) {
                    TableColumnMetaService.getInstance().deleteColumnsByTableId(((TablePO)tablePORef.get()).getTableId());
                }
            }, () -> {
                if (tableEntity.columns() != null && !tableEntity.columns().isEmpty()) {
                    TableColumnMetaService.getInstance().insertColumnPOs((TablePO)tablePORef.get(), tableEntity.columns());
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.TABLE, tableEntity.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertTable_aroundBody7$advice(TableMetaService ajc$this, TableEntity tableEntity, boolean overwrite, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableMetaService.insertTable_aroundBody6(ajc$this, tableEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableMetaService.insertTable_aroundBody6(ajc$this, tableEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableMetaService.insertTable_aroundBody6(ajc$this, tableEntity, overwrite, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ TableEntity updateTable_aroundBody8(TableMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        NameIdentifierUtil.checkTable(identifier);
        String tableName = identifier.name();
        Long schemaId = EntityIdService.getEntityId(NameIdentifier.of((String[])identifier.namespace().levels()), Entity.EntityType.SCHEMA);
        TablePO oldTablePO = ajc$this.getTablePOBySchemaIdAndName(schemaId, tableName);
        List<ColumnPO> oldTableColumns = TableColumnMetaService.getInstance().getColumnsByTableIdAndVersion(oldTablePO.getTableId(), oldTablePO.getCurrentVersion());
        TableEntity oldTableEntity = POConverters.fromTableAndColumnPOs(oldTablePO, oldTableColumns, identifier.namespace());
        TableEntity newTableEntity = (TableEntity)updater.apply(oldTableEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldTableEntity.id(), newTableEntity.id()), (String)"The updated table entity id: %s should be same with the table entity id before: %s", (Object)newTableEntity.id(), (Object)oldTableEntity.id());
        boolean isSchemaChanged = !newTableEntity.namespace().equals((Object)oldTableEntity.namespace());
        Long newSchemaId = isSchemaChanged ? EntityIdService.getEntityId(NameIdentifier.of((String[])newTableEntity.namespace().levels()), Entity.EntityType.SCHEMA) : schemaId;
        TablePO newTablePO = POConverters.updateTablePOWithVersionAndSchemaId(oldTablePO, newTableEntity, newSchemaId);
        AtomicInteger updateResult = new AtomicInteger(0);
        try {
            SessionUtils.doMultipleWithCommit(() -> updateResult.set(SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.updateTableMeta(newTablePO, oldTablePO, newSchemaId))), () -> SessionUtils.doWithoutCommit(TableVersionMapper.class, mapper -> {
                mapper.softDeleteTableVersionByTableIdAndVersion(oldTablePO.getTableId(), oldTablePO.getCurrentVersion());
                mapper.insertTableVersionOnDuplicateKeyUpdate(newTablePO);
            }), () -> {
                if (updateResult.get() > 0) {
                    TableColumnMetaService.getInstance().updateColumnPOsFromTableDiff(oldTableEntity, newTableEntity, newTablePO);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.TABLE, newTableEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult.get() > 0) {
            return newTableEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(identifier));
    }

    private static final /* synthetic */ Object updateTable_aroundBody9$advice(TableMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        TableEntity tableEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.updateTable_aroundBody8(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableMetaService.updateTable_aroundBody8(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableEntity result = TableMetaService.updateTable_aroundBody8(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                tableEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return tableEntity;
    }

    private static final /* synthetic */ boolean deleteTable_aroundBody10(TableMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        NameIdentifierUtil.checkTable(identifier);
        NamespacedEntityId namespacedEntityId = EntityIdService.getEntityIds(identifier, Entity.EntityType.TABLE);
        AtomicInteger deleteResult = new AtomicInteger(0);
        TablePO[] tablePOHolder = new TablePO[1];
        SessionUtils.doMultipleWithCommit(() -> {
            tablePOHolder[0] = this.getTablePOBySchemaIdAndName(namespacedEntityId.namespaceIds()[2], identifier.name());
        }, () -> deleteResult.set(SessionUtils.getWithoutCommit(TableMetaMapper.class, mapper -> mapper.softDeleteTableMetasByTableId(namespacedEntityId.entityId()))), () -> {
            if (deleteResult.get() > 0) {
                SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(namespacedEntityId.entityId(), MetadataObject.Type.TABLE.name()));
                TableColumnMetaService.getInstance().deleteColumnsByTableId(namespacedEntityId.entityId());
                SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByMetadataObject(namespacedEntityId.entityId(), MetadataObject.Type.TABLE.name()));
                SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetadataObject(namespacedEntityId.entityId(), MetadataObject.Type.TABLE.name()));
                SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByTableId(namespacedEntityId.entityId()));
                SessionUtils.doWithoutCommit(StatisticMetaMapper.class, mapper -> mapper.softDeleteStatisticsByEntityId(namespacedEntityId.entityId()));
                SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.softDeletePolicyMetadataObjectRelsByTableId(namespacedEntityId.entityId()));
                SessionUtils.doWithoutCommit(TableVersionMapper.class, mapper -> mapper.softDeleteTableVersionByTableIdAndVersion(namespacedEntityId.entityId(), tablePOHolder[0].getCurrentVersion()));
            }
        });
        return deleteResult.get() > 0;
    }

    private static final /* synthetic */ Object deleteTable_aroundBody11$advice(TableMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)TableMetaService.deleteTable_aroundBody10(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)TableMetaService.deleteTable_aroundBody10(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)TableMetaService.deleteTable_aroundBody10(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteTableMetasByLegacyTimeline_aroundBody12(TableMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        return SessionUtils.doWithCommitAndFetchResult(TableMetaMapper.class, mapper -> mapper.deleteTableMetasByLegacyTimeline(legacyTimeline, limit)) + ajc$this.deleteTableVersionByLegacyTimeline(legacyTimeline, limit);
    }

    private static final /* synthetic */ Object deleteTableMetasByLegacyTimeline_aroundBody13$advice(TableMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TableMetaService.deleteTableMetasByLegacyTimeline_aroundBody12(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TableMetaService.deleteTableMetasByLegacyTimeline_aroundBody12(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)TableMetaService.deleteTableMetasByLegacyTimeline_aroundBody12(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteTableVersionByLegacyTimeline_aroundBody14(TableMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        return SessionUtils.doWithCommitAndFetchResult(TableVersionMapper.class, mapper -> mapper.deleteTableVersionByLegacyTimeline(legacyTimeline, limit));
    }

    private static final /* synthetic */ Object deleteTableVersionByLegacyTimeline_aroundBody15$advice(TableMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TableMetaService.deleteTableVersionByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TableMetaService.deleteTableVersionByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)TableMetaService.deleteTableVersionByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TableMetaService.java", TableMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableIdBySchemaIdAndName", "org.apache.gravitino.storage.relational.service.TableMetaService", "java.lang.Long:java.lang.String", "schemaId:tableName", "", "java.lang.Long"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTableByIdentifier", "org.apache.gravitino.storage.relational.service.TableMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "org.apache.gravitino.meta.TableEntity"), 86);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listTablesByNamespace", "org.apache.gravitino.storage.relational.service.TableMetaService", "org.apache.gravitino.Namespace", "namespace", "", "java.util.List"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertTable", "org.apache.gravitino.storage.relational.service.TableMetaService", "org.apache.gravitino.meta.TableEntity:boolean", "tableEntity:overwrite", "java.io.IOException", "void"), 120);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateTable", "org.apache.gravitino.storage.relational.service.TableMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.TableEntity"), 173);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTable", "org.apache.gravitino.storage.relational.service.TableMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "boolean"), 243);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTableMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.TableMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 307);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTableVersionByLegacyTimeline", "org.apache.gravitino.storage.relational.service.TableMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 317);
    }
}

