/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.net.SocketIOWithTimeout;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class SocketOutputStream
extends OutputStream
implements WritableByteChannel {
    private Writer writer;

    public SocketOutputStream(WritableByteChannel channel, long timeout) throws IOException {
        SocketIOWithTimeout.checkChannelValidity(channel);
        this.writer = new Writer(channel, timeout);
    }

    public SocketOutputStream(Socket socket, long timeout) throws IOException {
        this(socket.getChannel(), timeout);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        while (buf.hasRemaining()) {
            try {
                if (this.write(buf) >= 0) continue;
                throw new IOException("The stream is closed");
            }
            catch (IOException e) {
                if (buf.capacity() > buf.remaining()) {
                    this.writer.close();
                }
                throw e;
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.writer.channel.close();
        this.writer.close();
    }

    public WritableByteChannel getChannel() {
        return this.writer.channel;
    }

    @Override
    public boolean isOpen() {
        return this.writer.isOpen();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.writer.doIO(src, 4);
    }

    public void waitForWritable() throws IOException {
        this.writer.waitForIO(4);
    }

    public void transferToFully(FileChannel fileCh, long position, int count, LongWritable waitForWritableTime, LongWritable transferToTime) throws IOException {
        long waitTime = 0L;
        long transferTime = 0L;
        while (count > 0) {
            long start = System.nanoTime();
            this.waitForWritable();
            long wait = System.nanoTime();
            int nTransfered = (int)fileCh.transferTo(position, count, this.getChannel());
            if (nTransfered == 0) {
                if (position >= fileCh.size()) {
                    throw new EOFException("EOF Reached. file size is " + fileCh.size() + " and " + count + " more bytes left to be " + "transfered.");
                }
            } else {
                if (nTransfered < 0) {
                    throw new IOException("Unexpected return of " + nTransfered + " from transferTo()");
                }
                position += (long)nTransfered;
                count -= nTransfered;
            }
            long transfer = System.nanoTime();
            waitTime += wait - start;
            transferTime += transfer - wait;
        }
        if (waitForWritableTime != null) {
            waitForWritableTime.set(waitTime);
        }
        if (transferToTime != null) {
            transferToTime.set(transferTime);
        }
    }

    public void transferToFully(FileChannel fileCh, long position, int count) throws IOException {
        this.transferToFully(fileCh, position, count, null, null);
    }

    public void setTimeout(int timeoutMs) {
        this.writer.setTimeout(timeoutMs);
    }

    private static class Writer
    extends SocketIOWithTimeout {
        WritableByteChannel channel;

        Writer(WritableByteChannel channel, long timeout) throws IOException {
            super((SelectableChannel)((Object)channel), timeout);
            this.channel = channel;
        }

        @Override
        int performIO(ByteBuffer buf) throws IOException {
            return this.channel.write(buf);
        }
    }
}

