/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.client;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.hive.client.HiveClient;
import org.apache.gravitino.hive.client.HiveClientClassLoader;
import org.apache.gravitino.hive.client.HiveClientImpl;
import org.apache.gravitino.hive.client.HiveExceptionConverter;
import org.apache.gravitino.hive.client.ProxyHiveClientImpl;
import org.apache.gravitino.hive.client.Util;
import org.apache.gravitino.hive.kerberos.AuthenticationConfig;
import org.apache.gravitino.hive.kerberos.KerberosClient;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveClientFactory.class);
    public static final String GRAVITINO_KEYTAB_FORMAT = "keytabs/gravitino-%s-keytab";
    private volatile HiveClientClassLoader backendClassLoader;
    private final Object classLoaderLock = new Object();
    private boolean enableKerberos;
    private boolean enableImpersonation = false;
    private KerberosClient kerberosClient;
    private final Configuration hadoopConf;
    private final Properties properties;
    private final String keytabPath;
    private final String name;

    public HiveClientFactory(Properties properties, String name) {
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"Properties cannot be null");
        this.name = name;
        this.properties = properties;
        this.keytabPath = String.format(GRAVITINO_KEYTAB_FORMAT, name);
        try {
            this.hadoopConf = new Configuration();
            Util.updateConfigurationFromProperties(properties, this.hadoopConf);
            this.initKerberosIfNecessary();
            if (this.enableKerberos) {
                HiveClient client = this.createHiveClient();
                this.kerberosClient.setHiveClient(client);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to initialize HiveClientFactory %s", this.name), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveClient createHiveClient() {
        if (this.backendClassLoader == null) {
            Object object = this.classLoaderLock;
            synchronized (object) {
                if (this.backendClassLoader == null) {
                    return this.createHiveClientWithBackend();
                }
            }
        }
        HiveClientClassLoader classLoader = this.backendClassLoader;
        try {
            HiveClient client = this.createHiveClientInternal(classLoader);
            LOG.info("Connected to Hive Metastore using cached Hive version {}", (Object)classLoader.getHiveVersion());
            return client;
        }
        catch (Exception e) {
            LOG.warn("Failed to connect to Hive Metastore using cached Hive version {}", (Object)classLoader.getHiveVersion(), (Object)e);
            throw new RuntimeException("Failed to connect to Hive Metastore", e);
        }
    }

    public HiveClient createHiveClientWithBackend() {
        HiveClient client = null;
        HiveClientClassLoader classloader = null;
        try {
            classloader = HiveClientClassLoader.createLoader(HiveClientClassLoader.HiveVersion.HIVE3, Thread.currentThread().getContextClassLoader());
            client = this.createHiveClientInternal(classloader);
            client.getCatalogs();
            LOG.info("Connected to Hive Metastore using Hive version HIVE3");
            this.backendClassLoader = classloader;
            return client;
        }
        catch (GravitinoRuntimeException e) {
            try {
                if (client != null) {
                    client.close();
                }
                if (classloader != null) {
                    classloader.close();
                }
                if (e.getMessage().contains("Invalid method name: 'get_catalogs'") || e.getMessage().contains("class not found")) {
                    classloader = HiveClientClassLoader.createLoader(HiveClientClassLoader.HiveVersion.HIVE2, Thread.currentThread().getContextClassLoader());
                    client = this.createHiveClientInternal(classloader);
                    LOG.info("Connected to Hive Metastore using Hive version HIVE2");
                    this.backendClassLoader = classloader;
                    return client;
                }
                throw e;
            }
            catch (Exception ex) {
                LOG.error("Failed to connect to Hive Metastore using both Hive3 and Hive2", (Throwable)ex);
                throw e;
            }
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.other(""));
        }
    }

    public static HiveClient createHiveClientImpl(HiveClientClassLoader.HiveVersion version, Properties properties, ClassLoader classloader) throws Exception {
        Class<?> hiveClientImplClass = classloader.loadClass(HiveClientImpl.class.getName());
        Constructor<?> hiveClientImplCtor = hiveClientImplClass.getConstructor(HiveClientClassLoader.HiveVersion.class, Properties.class);
        return (HiveClient)hiveClientImplCtor.newInstance(new Object[]{version, properties});
    }

    public static HiveClient createProxyHiveClientImpl(HiveClientClassLoader.HiveVersion version, Properties properties, UserGroupInformation ugi, ClassLoader classloader) throws Exception {
        Class<?> hiveClientImplClass = classloader.loadClass(ProxyHiveClientImpl.class.getName());
        Method createMethod = MethodUtils.getAccessibleMethod(hiveClientImplClass, (String)"createClient", (Class[])new Class[]{HiveClientClassLoader.HiveVersion.class, UserGroupInformation.class, Properties.class});
        return (HiveClient)createMethod.invoke(null, new Object[]{version, ugi, properties});
    }

    private HiveClient createHiveClientInternal(HiveClientClassLoader classloader) {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classloader);
        try {
            if (this.enableImpersonation) {
                UserGroupInformation ugi;
                if (this.enableKerberos) {
                    ugi = this.kerberosClient.loginProxyUser(PrincipalUtils.getCurrentUserName());
                } else {
                    ugi = UserGroupInformation.getCurrentUser();
                    if (!ugi.getUserName().equals(PrincipalUtils.getCurrentUserName())) {
                        ugi = UserGroupInformation.createProxyUser((String)PrincipalUtils.getCurrentUserName(), (UserGroupInformation)ugi);
                    }
                }
                HiveClient hiveClient = HiveClientFactory.createProxyHiveClientImpl(classloader.getHiveVersion(), this.properties, ugi, classloader);
                return hiveClient;
            }
            HiveClient ugi = HiveClientFactory.createHiveClientImpl(classloader.getHiveVersion(), this.properties, classloader);
            return ugi;
        }
        catch (Exception e) {
            throw HiveExceptionConverter.toGravitinoException(e, HiveExceptionConverter.ExceptionTarget.other(this.properties.getProperty("hive.metastore.uris")));
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private void initKerberosIfNecessary() {
        try {
            AuthenticationConfig authenticationConfig = new AuthenticationConfig(this.properties, this.hadoopConf);
            this.enableKerberos = authenticationConfig.isKerberosAuth();
            this.enableImpersonation = authenticationConfig.isImpersonationEnable();
            if (!this.enableKerberos) {
                return;
            }
            this.kerberosClient = new KerberosClient(this.properties, this.hadoopConf, true, this.keytabPath);
            this.kerberosClient.login();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize kerberos client", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.kerberosClient != null) {
                this.kerberosClient.close();
                this.kerberosClient = null;
            }
            Object object = this.classLoaderLock;
            synchronized (object) {
                if (this.backendClassLoader != null) {
                    this.backendClassLoader.close();
                    this.backendClassLoader = null;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to close HiveClientFactory", (Throwable)e);
        }
    }
}

