/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.gravitino.credential.CredentialProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialProviderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialProviderFactory.class);

    public static CredentialProvider create(String credentialType, Map<String, String> catalogProperties) {
        Class<? extends CredentialProvider> providerClz = CredentialProviderFactory.lookupCredentialProvider(credentialType);
        try {
            CredentialProvider provider = providerClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            provider.initialize(catalogProperties);
            return provider;
        }
        catch (Exception e) {
            LOG.warn("Create credential provider failed, {}", (Object)credentialType, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends CredentialProvider> lookupCredentialProvider(String credentialType) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ServiceLoader<CredentialProvider> serviceLoader = ServiceLoader.load(CredentialProvider.class, classLoader);
        List providers = Streams.stream(serviceLoader.iterator()).filter(credentialProvider -> credentialType.equalsIgnoreCase(credentialProvider.credentialType())).map(Object::getClass).collect(Collectors.toList());
        if (providers.isEmpty()) {
            throw new IllegalArgumentException("No credential provider found for: " + credentialType);
        }
        if (providers.size() > 1) {
            throw new IllegalArgumentException("Multiple credential providers found for: " + credentialType);
        }
        return (Class)Iterables.getOnlyElement(providers);
    }
}

