/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.AuthorizationUtils;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserRoleRelMapper;
import org.apache.gravitino.storage.relational.po.RolePO;
import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.gravitino.storage.relational.po.UserRoleRelPO;
import org.apache.gravitino.storage.relational.service.EntityIdService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.service.RoleMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class UserMetaService {
    private static final UserMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ Annotation ajc$anno$7;

    public static UserMetaService getInstance() {
        return INSTANCE;
    }

    private UserMetaService() {
    }

    private UserPO getUserPOByMetalakeIdAndName(Long metalakeId, String userName) {
        UserPO userPO = SessionUtils.getWithoutCommit(UserMetaMapper.class, mapper -> mapper.selectUserMetaByMetalakeIdAndName(metalakeId, userName));
        if (userPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.USER.name().toLowerCase(), userName});
        }
        return userPO;
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getUserIdByMetalakeIdAndName")
    public Long getUserIdByMetalakeIdAndName(Long metalakeId, String userName) {
        Long l = metalakeId;
        String string = userName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = UserMetaService.class.getDeclaredMethod("getUserIdByMetalakeIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)UserMetaService.getUserIdByMetalakeIdAndName_aroundBody1$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getUserByIdentifier")
    public UserEntity getUserByIdentifier(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = UserMetaService.class.getDeclaredMethod("getUserByIdentifier", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (UserEntity)UserMetaService.getUserByIdentifier_aroundBody3$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listUsersByRoleIdent")
    public List<UserEntity> listUsersByRoleIdent(NameIdentifier roleIdent) {
        NameIdentifier nameIdentifier = roleIdent;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = UserMetaService.class.getDeclaredMethod("listUsersByRoleIdent", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return (List)UserMetaService.listUsersByRoleIdent_aroundBody5$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertUser")
    public void insertUser(UserEntity userEntity, boolean overwritten) throws IOException {
        UserEntity userEntity2 = userEntity;
        boolean bl = overwritten;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)userEntity2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = UserMetaService.class.getDeclaredMethod("insertUser", UserEntity.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        UserMetaService.insertUser_aroundBody7$advice(this, userEntity2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteUser")
    public boolean deleteUser(NameIdentifier identifier) {
        NameIdentifier nameIdentifier = identifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)nameIdentifier);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = UserMetaService.class.getDeclaredMethod("deleteUser", NameIdentifier.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)UserMetaService.deleteUser_aroundBody9$advice(this, nameIdentifier, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateUser")
    public <E extends Entity & HasIdentifier> UserEntity updateUser(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        NameIdentifier nameIdentifier = identifier;
        Function<E, E> function = updater;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)nameIdentifier, function);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = UserMetaService.class.getDeclaredMethod("updateUser", NameIdentifier.class, Function.class).getAnnotation(Monitored.class);
        }
        return (UserEntity)UserMetaService.updateUser_aroundBody11$advice(this, nameIdentifier, function, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="listUsersByNamespace")
    public List<UserEntity> listUsersByNamespace(Namespace namespace, boolean allFields) {
        Namespace namespace2 = namespace;
        boolean bl = allFields;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)namespace2, (Object)Conversions.booleanObject((boolean)bl));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = UserMetaService.class.getDeclaredMethod("listUsersByNamespace", Namespace.class, Boolean.TYPE).getAnnotation(Monitored.class);
        }
        return (List)UserMetaService.listUsersByNamespace_aroundBody13$advice(this, namespace2, bl, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteUserMetasByLegacyTimeline")
    public int deleteUserMetasByLegacyTimeline(long legacyTimeline, int limit) {
        long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$7;
        if (annotation == null) {
            annotation = ajc$anno$7 = UserMetaService.class.getDeclaredMethod("deleteUserMetasByLegacyTimeline", Long.TYPE, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)UserMetaService.deleteUserMetasByLegacyTimeline_aroundBody15$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    private static /* synthetic */ void lambda$updateUser$19(Set deleteRoleIds, UserEntity newEntity) {
        if (deleteRoleIds.isEmpty()) {
            return;
        }
        SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.softDeleteUserRoleRelByUserAndRoles(newEntity.id(), Lists.newArrayList((Iterable)deleteRoleIds)));
    }

    private static /* synthetic */ void lambda$updateUser$17(Set insertRoleIds, UserEntity newEntity) {
        if (insertRoleIds.isEmpty()) {
            return;
        }
        SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.batchInsertUserRoleRel(POConverters.initializeUserRoleRelsPOWithVersion(newEntity, Lists.newArrayList((Iterable)insertRoleIds))));
    }

    static {
        UserMetaService.ajc$preClinit();
        INSTANCE = new UserMetaService();
    }

    private static final /* synthetic */ Long getUserIdByMetalakeIdAndName_aroundBody0(UserMetaService ajc$this, Long metalakeId, String userName, JoinPoint joinPoint) {
        Long userId = SessionUtils.getWithoutCommit(UserMetaMapper.class, mapper -> mapper.selectUserIdByMetalakeIdAndName(metalakeId, userName));
        if (userId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.USER.name().toLowerCase(), userName});
        }
        return userId;
    }

    private static final /* synthetic */ Object getUserIdByMetalakeIdAndName_aroundBody1$advice(UserMetaService ajc$this, Long metalakeId, String userName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.getUserIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, userName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.getUserIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, userName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = UserMetaService.getUserIdByMetalakeIdAndName_aroundBody0(ajc$this, metalakeId, userName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ UserEntity getUserByIdentifier_aroundBody2(UserMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        AuthorizationUtils.checkUser(identifier);
        Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(identifier.namespace().level(0));
        UserPO userPO = ajc$this.getUserPOByMetalakeIdAndName(metalakeId, identifier.name());
        List<RolePO> rolePOs = RoleMetaService.getInstance().listRolesByUserId(userPO.getUserId());
        return POConverters.fromUserPO(userPO, rolePOs, identifier.namespace());
    }

    private static final /* synthetic */ Object getUserByIdentifier_aroundBody3$advice(UserMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        UserEntity userEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.getUserByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.getUserByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                UserEntity result = UserMetaService.getUserByIdentifier_aroundBody2(ajc$this, identifier, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                userEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return userEntity;
    }

    private static final /* synthetic */ List listUsersByRoleIdent_aroundBody4(UserMetaService ajc$this, NameIdentifier roleIdent, JoinPoint joinPoint) {
        RoleEntity roleEntity = RoleMetaService.getInstance().getRoleByIdentifier(roleIdent);
        List userPOs = SessionUtils.getWithoutCommit(UserMetaMapper.class, mapper -> mapper.listUsersByRoleId(roleEntity.id()));
        return userPOs.stream().map(po -> POConverters.fromUserPO(po, Collections.emptyList(), AuthorizationUtils.ofUserNamespace(roleIdent.namespace().level(0)))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listUsersByRoleIdent_aroundBody5$advice(UserMetaService ajc$this, NameIdentifier roleIdent, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.listUsersByRoleIdent_aroundBody4(ajc$this, roleIdent, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.listUsersByRoleIdent_aroundBody4(ajc$this, roleIdent, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = UserMetaService.listUsersByRoleIdent_aroundBody4(ajc$this, roleIdent, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ void insertUser_aroundBody6(UserMetaService ajc$this, UserEntity userEntity, boolean overwritten, JoinPoint joinPoint) {
        try {
            AuthorizationUtils.checkUser(userEntity.nameIdentifier());
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(userEntity.namespace().level(0));
            UserPO.Builder builder = UserPO.builder().withMetalakeId(metalakeId);
            UserPO userPO = POConverters.initializeUserPOWithVersion(userEntity, builder);
            List<Long> roleIds = Optional.ofNullable(userEntity.roleIds()).orElse(Lists.newArrayList());
            List<UserRoleRelPO> userRoleRelPOs = POConverters.initializeUserRoleRelsPOWithVersion(userEntity, roleIds);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(UserMetaMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertUserMetaOnDuplicateKeyUpdate(userPO);
                } else {
                    mapper.insertUserMeta(userPO);
                }
            }), () -> SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> {
                if (overwritten) {
                    mapper.softDeleteUserRoleRelByUserId(userEntity.id());
                }
                if (!userRoleRelPOs.isEmpty()) {
                    mapper.batchInsertUserRoleRel(userRoleRelPOs);
                }
            }));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.USER, userEntity.nameIdentifier().toString());
            throw re;
        }
    }

    private static final /* synthetic */ Object insertUser_aroundBody7$advice(UserMetaService ajc$this, UserEntity userEntity, boolean overwritten, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                UserMetaService.insertUser_aroundBody6(ajc$this, userEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                UserMetaService.insertUser_aroundBody6(ajc$this, userEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                UserMetaService.insertUser_aroundBody6(ajc$this, userEntity, overwritten, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ boolean deleteUser_aroundBody8(UserMetaService ajc$this, NameIdentifier identifier, JoinPoint joinPoint) {
        AuthorizationUtils.checkUser(identifier);
        Long userId = EntityIdService.getEntityId(identifier, Entity.EntityType.USER);
        SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(UserMetaMapper.class, mapper -> mapper.softDeleteUserMetaByUserId(userId)), () -> SessionUtils.doWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.softDeleteUserRoleRelByUserId(userId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByOwnerIdAndType(userId, Entity.EntityType.USER.name())));
        return true;
    }

    private static final /* synthetic */ Object deleteUser_aroundBody9$advice(UserMetaService ajc$this, NameIdentifier identifier, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)UserMetaService.deleteUser_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)UserMetaService.deleteUser_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)UserMetaService.deleteUser_aroundBody8(ajc$this, identifier, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ UserEntity updateUser_aroundBody10(UserMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint joinPoint) {
        AuthorizationUtils.checkUser(identifier);
        Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(identifier.namespace().level(0));
        UserPO oldUserPO = ajc$this.getUserPOByMetalakeIdAndName(metalakeId, identifier.name());
        List<RolePO> rolePOs = RoleMetaService.getInstance().listRolesByUserId(oldUserPO.getUserId());
        UserEntity oldUserEntity = POConverters.fromUserPO(oldUserPO, rolePOs, identifier.namespace());
        UserEntity newEntity = (UserEntity)updater.apply(oldUserEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldUserEntity.id(), newEntity.id()), (String)"The updated user entity id: %s should be same with the user entity id before: %s", (Object)newEntity.id(), (Object)oldUserEntity.id());
        HashSet oldRoleIds = oldUserEntity.roleIds() == null ? Sets.newHashSet() : Sets.newHashSet(oldUserEntity.roleIds());
        HashSet newRoleIds = newEntity.roleIds() == null ? Sets.newHashSet() : Sets.newHashSet(newEntity.roleIds());
        Sets.SetView insertRoleIds = Sets.difference((Set)newRoleIds, (Set)oldRoleIds);
        Sets.SetView deleteRoleIds = Sets.difference((Set)oldRoleIds, (Set)newRoleIds);
        if (insertRoleIds.isEmpty() && deleteRoleIds.isEmpty()) {
            return newEntity;
        }
        try {
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(UserMetaMapper.class, mapper -> mapper.updateUserMeta(POConverters.updateUserPOWithVersion(oldUserPO, newEntity), oldUserPO)), () -> UserMetaService.lambda$updateUser$17((Set)insertRoleIds, newEntity), () -> UserMetaService.lambda$updateUser$19((Set)deleteRoleIds, newEntity));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.USER, newEntity.nameIdentifier().toString());
            throw re;
        }
        return newEntity;
    }

    private static final /* synthetic */ Object updateUser_aroundBody11$advice(UserMetaService ajc$this, NameIdentifier identifier, Function updater, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        UserEntity userEntity;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.updateUser_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.updateUser_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                UserEntity result = UserMetaService.updateUser_aroundBody10(ajc$this, identifier, updater, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                userEntity = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return userEntity;
    }

    private static final /* synthetic */ List listUsersByNamespace_aroundBody12(UserMetaService ajc$this, Namespace namespace, boolean allFields, JoinPoint joinPoint) {
        AuthorizationUtils.checkUserNamespace(namespace);
        String metalakeName = namespace.level(0);
        if (allFields) {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalakeName);
            List userPOs = SessionUtils.getWithoutCommit(UserMetaMapper.class, mapper -> mapper.listExtendedUserPOsByMetalakeId(metalakeId));
            return userPOs.stream().map(po -> POConverters.fromExtendedUserPO(po, AuthorizationUtils.ofUserNamespace(metalakeName))).collect(Collectors.toList());
        }
        List userPOs = SessionUtils.getWithoutCommit(UserMetaMapper.class, mapper -> mapper.listUserPOsByMetalake(metalakeName));
        return userPOs.stream().map(po -> POConverters.fromUserPO(po, Collections.emptyList(), AuthorizationUtils.ofUserNamespace(metalakeName))).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object listUsersByNamespace_aroundBody13$advice(UserMetaService ajc$this, Namespace namespace, boolean allFields, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.listUsersByNamespace_aroundBody12(ajc$this, namespace, allFields, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return UserMetaService.listUsersByNamespace_aroundBody12(ajc$this, namespace, allFields, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = UserMetaService.listUsersByNamespace_aroundBody12(ajc$this, namespace, allFields, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ int deleteUserMetasByLegacyTimeline_aroundBody14(UserMetaService ajc$this, long legacyTimeline, int limit, JoinPoint joinPoint) {
        int[] userDeletedCount = new int[]{0};
        int[] userRoleRelDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            userDeletedCount[0] = SessionUtils.getWithoutCommit(UserMetaMapper.class, mapper -> mapper.deleteUserMetasByLegacyTimeline(legacyTimeline, limit));
        }, () -> {
            userRoleRelDeletedCount[0] = SessionUtils.getWithoutCommit(UserRoleRelMapper.class, mapper -> mapper.deleteUserRoleRelMetasByLegacyTimeline(legacyTimeline, limit));
        });
        return userDeletedCount[0] + userRoleRelDeletedCount[0];
    }

    private static final /* synthetic */ Object deleteUserMetasByLegacyTimeline_aroundBody15$advice(UserMetaService ajc$this, long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)UserMetaService.deleteUserMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)UserMetaService.deleteUserMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)UserMetaService.deleteUserMetasByLegacyTimeline_aroundBody14(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserMetaService.java", UserMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserIdByMetalakeIdAndName", "org.apache.gravitino.storage.relational.service.UserMetaService", "java.lang.Long:java.lang.String", "metalakeId:userName", "", "java.lang.Long"), 83);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserByIdentifier", "org.apache.gravitino.storage.relational.service.UserMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "org.apache.gravitino.meta.UserEntity"), 101);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listUsersByRoleIdent", "org.apache.gravitino.storage.relational.service.UserMetaService", "org.apache.gravitino.NameIdentifier", "roleIdent", "", "java.util.List"), 115);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insertUser", "org.apache.gravitino.storage.relational.service.UserMetaService", "org.apache.gravitino.meta.UserEntity:boolean", "userEntity:overwritten", "java.io.IOException", "void"), 132);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "org.apache.gravitino.storage.relational.service.UserMetaService", "org.apache.gravitino.NameIdentifier", "identifier", "", "boolean"), 175);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateUser", "org.apache.gravitino.storage.relational.service.UserMetaService", "org.apache.gravitino.NameIdentifier:java.util.function.Function", "identifier:updater", "java.io.IOException", "org.apache.gravitino.meta.UserEntity"), 198);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listUsersByNamespace", "org.apache.gravitino.storage.relational.service.UserMetaService", "org.apache.gravitino.Namespace:boolean", "namespace:allFields", "", "java.util.List"), 268);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUserMetasByLegacyTimeline", "org.apache.gravitino.storage.relational.service.UserMetaService", "long:int", "legacyTimeline:limit", "", "int"), 301);
    }
}

