/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.inmemory;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.inmemory.InMemoryFileIO;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.view.BaseMetastoreViewCatalog;
import org.apache.iceberg.view.BaseViewOperations;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewUtil;

public class InMemoryCatalog
extends BaseMetastoreViewCatalog
implements SupportsNamespaces,
Closeable {
    private static final Joiner SLASH = Joiner.on((String)"/");
    private static final Joiner DOT = Joiner.on((String)".");
    private final ConcurrentMap<Namespace, Map<String, String>> namespaces = Maps.newConcurrentMap();
    private final ConcurrentMap<TableIdentifier, String> tables = Maps.newConcurrentMap();
    private final ConcurrentMap<TableIdentifier, String> views = Maps.newConcurrentMap();
    private FileIO io;
    private String catalogName;
    private String warehouseLocation;
    private CloseableGroup closeableGroup;
    private Map<String, String> catalogProperties;

    @Override
    public String name() {
        return this.catalogName;
    }

    @Override
    public void initialize(String name, Map<String, String> properties) {
        this.catalogName = name != null ? name : InMemoryCatalog.class.getSimpleName();
        this.catalogProperties = ImmutableMap.copyOf(properties);
        String warehouse = properties.getOrDefault("warehouse", "");
        this.warehouseLocation = warehouse.replaceAll("/*$", "");
        this.io = new InMemoryFileIO();
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.addCloseable((Closeable)this.metricsReporter());
        this.closeableGroup.setSuppressCloseFailure(true);
    }

    @Override
    protected TableOperations newTableOps(TableIdentifier tableIdentifier) {
        return new InMemoryTableOperations(this.io, tableIdentifier);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        return SLASH.join((Object)this.defaultNamespaceLocation(tableIdentifier.namespace()), (Object)tableIdentifier.name(), new Object[0]);
    }

    private String defaultNamespaceLocation(Namespace namespace) {
        if (namespace.isEmpty()) {
            return this.warehouseLocation;
        }
        return SLASH.join((Object)this.warehouseLocation, (Object)SLASH.join((Object[])namespace.levels()), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropTable(TableIdentifier tableIdentifier, boolean purge) {
        TableOperations ops = this.newTableOps(tableIdentifier);
        TableMetadata lastMetadata = purge && ops.current() != null ? ops.current() : null;
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (null == this.tables.remove(tableIdentifier)) {
                return false;
            }
        }
        if (purge && lastMetadata != null) {
            CatalogUtil.dropTableData(ops.io(), lastMetadata);
        }
        return true;
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        if (!this.namespaceExists(namespace) && !namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Cannot list tables for namespace. Namespace does not exist: %s", new Object[]{namespace});
        }
        return this.tables.keySet().stream().filter(t -> t.namespace().equals((Object)namespace)).sorted(Comparator.comparing(TableIdentifier::toString)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTable(TableIdentifier from, TableIdentifier to) {
        if (from.equals((Object)to)) {
            return;
        }
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (!this.namespaceExists(to.namespace())) {
                throw new NoSuchNamespaceException("Cannot rename %s to %s. Namespace does not exist: %s", new Object[]{from, to, to.namespace()});
            }
            String fromLocation = (String)this.tables.get(from);
            if (null == fromLocation) {
                throw new NoSuchTableException("Cannot rename %s to %s. Table does not exist", new Object[]{from, to});
            }
            if (this.tables.containsKey(to)) {
                throw new AlreadyExistsException("Cannot rename %s to %s. Table already exists", new Object[]{from, to});
            }
            if (this.views.containsKey(to)) {
                throw new AlreadyExistsException("Cannot rename %s to %s. View already exists", new Object[]{from, to});
            }
            this.tables.put(to, fromLocation);
            this.tables.remove(from);
        }
    }

    public void createNamespace(Namespace namespace) {
        this.createNamespace(namespace, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNamespace(Namespace namespace, Map<String, String> metadata) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (this.namespaceExists(namespace)) {
                throw new AlreadyExistsException("Cannot create namespace %s. Namespace already exists", new Object[]{namespace});
            }
            this.namespaces.put(namespace, (Map<String, String>)ImmutableMap.copyOf(metadata));
        }
    }

    public boolean namespaceExists(Namespace namespace) {
        return this.namespaces.containsKey(namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropNamespace(Namespace namespace) throws NamespaceNotEmptyException {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (!this.namespaceExists(namespace)) {
                return false;
            }
            List<TableIdentifier> tableIdentifiers = this.listTables(namespace);
            if (!tableIdentifiers.isEmpty()) {
                throw new NamespaceNotEmptyException("Namespace %s is not empty. Contains %d table(s).", new Object[]{namespace, tableIdentifiers.size()});
            }
            return this.namespaces.remove(namespace) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setProperties(Namespace namespace, Map<String, String> properties) throws NoSuchNamespaceException {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (!this.namespaceExists(namespace)) {
                throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
            }
            this.namespaces.computeIfPresent(namespace, (k, v) -> ImmutableMap.builder().putAll(v).putAll(properties).buildKeepingLast());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProperties(Namespace namespace, Set<String> properties) throws NoSuchNamespaceException {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (!this.namespaceExists(namespace)) {
                throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
            }
            this.namespaces.computeIfPresent(namespace, (k, v) -> {
                HashMap newProperties = Maps.newHashMap((Map)v);
                properties.forEach(newProperties::remove);
                return ImmutableMap.copyOf((Map)newProperties);
            });
            return true;
        }
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) throws NoSuchNamespaceException {
        Map properties = (Map)this.namespaces.get(namespace);
        if (properties == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        return ImmutableMap.copyOf((Map)properties);
    }

    public List<Namespace> listNamespaces() {
        return this.namespaces.keySet().stream().filter(n -> !n.isEmpty()).map(n -> n.level(0)).distinct().sorted().map(xva$0 -> Namespace.of((String[])new String[]{xva$0})).collect(Collectors.toList());
    }

    public List<Namespace> listNamespaces(Namespace namespace) throws NoSuchNamespaceException {
        String searchNamespaceString = namespace.isEmpty() ? "" : DOT.join((Object[])namespace.levels()) + ".";
        int searchNumberOfLevels = namespace.levels().length;
        List filteredNamespaces = this.namespaces.keySet().stream().filter(n -> !n.isEmpty()).filter(n -> DOT.join((Object[])n.levels()).startsWith(searchNamespaceString)).collect(Collectors.toList());
        if (!this.namespaces.containsKey(namespace) && filteredNamespaces.isEmpty()) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        return filteredNamespaces.stream().map(n -> Namespace.of((String[])Arrays.copyOf(n.levels(), searchNumberOfLevels + 1))).distinct().sorted(Comparator.comparing(n -> DOT.join((Object[])n.levels()))).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        this.closeableGroup.close();
        this.namespaces.clear();
        this.tables.clear();
        this.views.clear();
    }

    public List<TableIdentifier> listViews(Namespace namespace) {
        if (!this.namespaceExists(namespace) && !namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Cannot list views for namespace. Namespace does not exist: %s", new Object[]{namespace});
        }
        return this.views.keySet().stream().filter(v -> v.namespace().equals((Object)namespace)).sorted(Comparator.comparing(TableIdentifier::toString)).collect(Collectors.toList());
    }

    @Override
    protected ViewOperations newViewOps(TableIdentifier identifier) {
        return new InMemoryViewOperations(this.io, identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropView(TableIdentifier identifier) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            return null != this.views.remove(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameView(TableIdentifier from, TableIdentifier to) {
        if (from.equals((Object)to)) {
            return;
        }
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (!this.namespaceExists(to.namespace())) {
                throw new NoSuchNamespaceException("Cannot rename %s to %s. Namespace does not exist: %s", new Object[]{from, to, to.namespace()});
            }
            String fromViewLocation = (String)this.views.get(from);
            if (null == fromViewLocation) {
                throw new NoSuchViewException("Cannot rename %s to %s. View does not exist", new Object[]{from, to});
            }
            if (this.tables.containsKey(to)) {
                throw new AlreadyExistsException("Cannot rename %s to %s. Table already exists", new Object[]{from, to});
            }
            if (this.views.containsKey(to)) {
                throw new AlreadyExistsException("Cannot rename %s to %s. View already exists", new Object[]{from, to});
            }
            this.views.put(to, fromViewLocation);
            this.views.remove(from);
        }
    }

    @Override
    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }

    private class InMemoryTableOperations
    extends BaseMetastoreTableOperations {
        private final FileIO fileIO;
        private final TableIdentifier tableIdentifier;
        private final String fullTableName;

        InMemoryTableOperations(FileIO fileIO, TableIdentifier tableIdentifier) {
            this.fileIO = fileIO;
            this.tableIdentifier = tableIdentifier;
            this.fullTableName = InMemoryCatalog.fullTableName(InMemoryCatalog.this.catalogName, tableIdentifier);
        }

        @Override
        public void doRefresh() {
            String latestLocation = (String)InMemoryCatalog.this.tables.get(this.tableIdentifier);
            if (latestLocation == null) {
                this.disableRefresh();
            } else {
                this.refreshFromMetadataLocation(latestLocation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doCommit(TableMetadata base, TableMetadata metadata) {
            String newLocation = this.writeNewMetadataIfRequired(base == null, metadata);
            String oldLocation = base == null ? null : base.metadataFileLocation();
            InMemoryCatalog inMemoryCatalog = InMemoryCatalog.this;
            synchronized (inMemoryCatalog) {
                if (null == base && !InMemoryCatalog.this.namespaceExists(this.tableIdentifier.namespace())) {
                    throw new NoSuchNamespaceException("Cannot create table %s. Namespace does not exist: %s", new Object[]{this.tableIdentifier, this.tableIdentifier.namespace()});
                }
                if (InMemoryCatalog.this.views.containsKey(this.tableIdentifier)) {
                    throw new AlreadyExistsException("View with same name already exists: %s", new Object[]{this.tableIdentifier});
                }
                InMemoryCatalog.this.tables.compute(this.tableIdentifier, (k, existingLocation) -> {
                    if (!Objects.equal((Object)existingLocation, (Object)oldLocation)) {
                        if (null == base) {
                            throw new AlreadyExistsException("Table already exists: %s", new Object[]{this.tableName()});
                        }
                        if (null == existingLocation) {
                            throw new NoSuchTableException("Table does not exist: %s", new Object[]{this.tableName()});
                        }
                        throw new CommitFailedException("Cannot commit to table %s metadata location from %s to %s because it has been concurrently modified to %s", new Object[]{this.tableIdentifier, oldLocation, newLocation, existingLocation});
                    }
                    return newLocation;
                });
            }
        }

        @Override
        public FileIO io() {
            return this.fileIO;
        }

        @Override
        protected String tableName() {
            return this.fullTableName;
        }
    }

    private class InMemoryViewOperations
    extends BaseViewOperations {
        private final FileIO io;
        private final TableIdentifier identifier;
        private final String fullViewName;

        InMemoryViewOperations(FileIO io, TableIdentifier identifier) {
            this.io = io;
            this.identifier = identifier;
            this.fullViewName = ViewUtil.fullViewName(InMemoryCatalog.this.catalogName, identifier);
        }

        @Override
        public void doRefresh() {
            String latestLocation = (String)InMemoryCatalog.this.views.get(this.identifier);
            if (latestLocation == null) {
                this.disableRefresh();
            } else {
                this.refreshFromMetadataLocation(latestLocation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doCommit(ViewMetadata base, ViewMetadata metadata) {
            String newLocation = this.writeNewMetadataIfRequired(metadata);
            String oldLocation = base == null ? null : this.currentMetadataLocation();
            InMemoryCatalog inMemoryCatalog = InMemoryCatalog.this;
            synchronized (inMemoryCatalog) {
                if (null == base && !InMemoryCatalog.this.namespaceExists(this.identifier.namespace())) {
                    throw new NoSuchNamespaceException("Cannot create view %s. Namespace does not exist: %s", new Object[]{this.identifier, this.identifier.namespace()});
                }
                if (InMemoryCatalog.this.tables.containsKey(this.identifier)) {
                    throw new AlreadyExistsException("Table with same name already exists: %s", new Object[]{this.identifier});
                }
                InMemoryCatalog.this.views.compute(this.identifier, (k, existingLocation) -> {
                    if (!Objects.equal((Object)existingLocation, (Object)oldLocation)) {
                        if (null == base) {
                            throw new AlreadyExistsException("View already exists: %s", new Object[]{this.identifier});
                        }
                        if (null == existingLocation) {
                            throw new NoSuchViewException("View does not exist: %s", new Object[]{this.identifier});
                        }
                        throw new CommitFailedException("Cannot commit to view %s metadata location from %s to %s because it has been concurrently modified to %s", new Object[]{this.identifier, oldLocation, newLocation, existingLocation});
                    }
                    return newLocation;
                });
            }
        }

        @Override
        public FileIO io() {
            return this.io;
        }

        @Override
        protected String viewName() {
            return this.fullViewName;
        }
    }
}

