/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.rest.RESTRequest;

@JsonDeserialize(builder=OwnerSetRequestBuilder.class)
public class OwnerSetRequest
implements RESTRequest {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final Owner.Type type;

    public OwnerSetRequest() {
        this(null, null);
    }

    public OwnerSetRequest(String name, Owner.Type type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\"name\" field is required and cannot be empty");
        Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"\"type\" field is required and cannot be empty");
    }

    public static OwnerSetRequestBuilder builder() {
        return new OwnerSetRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Owner.Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwnerSetRequest)) {
            return false;
        }
        OwnerSetRequest other = (OwnerSetRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Owner.Type this$type = this.getType();
        Owner.Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OwnerSetRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Owner.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "OwnerSetRequest(name=" + this.getName() + ", type=" + String.valueOf(this.getType()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class OwnerSetRequestBuilder {
        private String name;
        private Owner.Type type;

        OwnerSetRequestBuilder() {
        }

        @JsonProperty(value="name")
        public OwnerSetRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="type")
        public OwnerSetRequestBuilder type(Owner.Type type) {
            this.type = type;
            return this;
        }

        public OwnerSetRequest build() {
            return new OwnerSetRequest(this.name, this.type);
        }

        public String toString() {
            return "OwnerSetRequest.OwnerSetRequestBuilder(name=" + this.name + ", type=" + String.valueOf(this.type) + ")";
        }
    }
}

