/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import java.util.Arrays;
import org.apache.gravitino.dto.model.ModelVersionDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;

public class ModelVersionInfoListResponse
extends BaseResponse {
    @JsonProperty(value="infos")
    private ModelVersionDTO[] versions;

    public ModelVersionInfoListResponse(ModelVersionDTO[] versions) {
        super(0);
        this.versions = versions;
    }

    public ModelVersionInfoListResponse() {
        this.versions = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.versions != null, "version infos cannot be null");
    }

    public ModelVersionDTO[] getVersions() {
        return this.versions;
    }

    @Override
    public String toString() {
        return "ModelVersionInfoListResponse(versions=" + Arrays.deepToString(this.getVersions()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelVersionInfoListResponse)) {
            return false;
        }
        ModelVersionInfoListResponse other = (ModelVersionInfoListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getVersions(), other.getVersions());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ModelVersionInfoListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getVersions());
        return result;
    }
}

