/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.internal.FallbackAddressPortExtractor;
import java.util.logging.Level;
import java.util.logging.Logger;

final class HttpAddressPortExtractor<REQUEST>
implements FallbackAddressPortExtractor<REQUEST> {
    private static final Logger logger = Logger.getLogger(HttpCommonAttributesGetter.class.getName());
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;

    HttpAddressPortExtractor(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(FallbackAddressPortExtractor.AddressPortSink sink2, REQUEST request) {
        String host = HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "host"));
        if (host == null) {
            return;
        }
        int hostHeaderSeparator = host.indexOf(58);
        if (hostHeaderSeparator == -1) {
            sink2.setAddress(host);
            return;
        }
        sink2.setAddress(host.substring(0, hostHeaderSeparator));
        try {
            sink2.setPort(Integer.parseInt(host.substring(hostHeaderSeparator + 1)));
        }
        catch (NumberFormatException e) {
            logger.log(Level.FINE, e.getMessage(), e);
        }
    }
}

