/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import com.google.common.base.Preconditions;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Set;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.client.GravitinoMetalake;
import org.apache.gravitino.trino.connector.GravitinoDataSourceProvider;
import org.apache.gravitino.trino.connector.GravitinoMetadata;
import org.apache.gravitino.trino.connector.GravitinoNodePartitioningProvider;
import org.apache.gravitino.trino.connector.GravitinoPageSinkProvider;
import org.apache.gravitino.trino.connector.GravitinoRecordSetProvider;
import org.apache.gravitino.trino.connector.GravitinoSplitManager;
import org.apache.gravitino.trino.connector.GravitinoTransactionHandle;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorContext;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadata;

public class GravitinoConnector
implements Connector {
    private final NameIdentifier catalogIdentifier;
    private final CatalogConnectorContext catalogConnectorContext;

    public GravitinoConnector(NameIdentifier catalogIdentifier, CatalogConnectorContext catalogConnectorContext) {
        this.catalogIdentifier = catalogIdentifier;
        this.catalogConnectorContext = catalogConnectorContext;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        Preconditions.checkArgument((internalConnector != null ? 1 : 0) != 0, (Object)"Internal connector must not be null");
        ConnectorTransactionHandle internalTransactionHandler = internalConnector.beginTransaction(isolationLevel, readOnly, autoCommit);
        Preconditions.checkArgument((internalTransactionHandler != null ? 1 : 0) != 0, (Object)"Transaction handler must not be null");
        return new GravitinoTransactionHandle(internalTransactionHandler);
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        GravitinoTransactionHandle gravitinoTransactionHandle = (GravitinoTransactionHandle)transactionHandle;
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        ConnectorMetadata internalMetadata = internalConnector.getMetadata(session, gravitinoTransactionHandle.getInternalHandle());
        Preconditions.checkArgument((internalMetadata != null ? 1 : 0) != 0, (Object)"Internal metadata must not be null");
        GravitinoMetalake metalake = this.catalogConnectorContext.getMetalake();
        CatalogConnectorMetadata catalogConnectorMetadata = new CatalogConnectorMetadata(metalake, this.catalogIdentifier);
        return new GravitinoMetadata(catalogConnectorMetadata, this.catalogConnectorContext.getMetadataAdapter(), internalMetadata);
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.catalogConnectorContext.getTableProperties();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        return internalConnector.getSessionProperties();
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.catalogConnectorContext.getColumnProperties();
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.catalogConnectorContext.getSchemaProperties();
    }

    public ConnectorSplitManager getSplitManager() {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        ConnectorSplitManager splitManager = internalConnector.getSplitManager();
        return new GravitinoSplitManager(splitManager);
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        ConnectorPageSourceProvider internalPageSourceProvider = internalConnector.getPageSourceProvider();
        return new GravitinoDataSourceProvider(internalPageSourceProvider);
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        ConnectorRecordSetProvider internalRecordSetProvider = internalConnector.getRecordSetProvider();
        return new GravitinoRecordSetProvider(internalRecordSetProvider);
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        ConnectorPageSinkProvider pageSinkProvider = internalConnector.getPageSinkProvider();
        return new GravitinoPageSinkProvider(pageSinkProvider);
    }

    public void commit(ConnectorTransactionHandle transactionHandle) {
        GravitinoTransactionHandle gravitinoTransactionHandle = (GravitinoTransactionHandle)transactionHandle;
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        internalConnector.commit(gravitinoTransactionHandle.getInternalHandle());
    }

    public ConnectorAccessControl getAccessControl() {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        return internalConnector.getAccessControl();
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return this.catalogConnectorContext.getInternalConnector().getCapabilities();
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        Connector internalConnector = this.catalogConnectorContext.getInternalConnector();
        ConnectorNodePartitioningProvider nodePartitioningProvider = internalConnector.getNodePartitioningProvider();
        return new GravitinoNodePartitioningProvider(nodePartitioningProvider);
    }
}

