/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.hadoop.shaded.org.apache.ftpserver.FtpServer;
import org.apache.hadoop.shaded.org.apache.ftpserver.FtpServerFactory;
import org.apache.hadoop.shaded.org.apache.ftpserver.ftplet.Authority;
import org.apache.hadoop.shaded.org.apache.ftpserver.ftplet.FtpException;
import org.apache.hadoop.shaded.org.apache.ftpserver.ftplet.User;
import org.apache.hadoop.shaded.org.apache.ftpserver.ftplet.UserManager;
import org.apache.hadoop.shaded.org.apache.ftpserver.impl.DefaultFtpServer;
import org.apache.hadoop.shaded.org.apache.ftpserver.listener.Listener;
import org.apache.hadoop.shaded.org.apache.ftpserver.listener.ListenerFactory;
import org.apache.hadoop.shaded.org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.hadoop.shaded.org.apache.ftpserver.usermanager.impl.BaseUser;

public class FtpTestServer {
    private int port;
    private Path ftpRoot;
    private UserManager userManager;
    private FtpServer server;

    public FtpTestServer(Path ftpRoot) {
        this.ftpRoot = ftpRoot;
        this.userManager = new PropertiesUserManagerFactory().createUserManager();
        FtpServerFactory serverFactory = this.createServerFactory();
        serverFactory.setUserManager(this.userManager);
        this.server = serverFactory.createServer();
    }

    public FtpTestServer start() throws Exception {
        this.server.start();
        Listener listener = (Listener)((DefaultFtpServer)this.server).getListeners().get("default");
        this.port = listener.getPort();
        return this;
    }

    public Path getFtpRoot() {
        return this.ftpRoot;
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        if (!this.server.isStopped()) {
            this.server.stop();
        }
    }

    public BaseUser addUser(String name, String password, Authority ... authorities) throws IOException, FtpException {
        BaseUser user = new BaseUser();
        user.setName(name);
        user.setPassword(password);
        Path userHome = Files.createDirectory(this.ftpRoot.resolve(name), new FileAttribute[0]);
        user.setHomeDirectory(userHome.toString());
        user.setAuthorities(Arrays.asList(authorities));
        this.userManager.save((User)user);
        return user;
    }

    private FtpServerFactory createServerFactory() {
        FtpServerFactory serverFactory = new FtpServerFactory();
        ListenerFactory defaultListener = new ListenerFactory();
        defaultListener.setPort(0);
        serverFactory.addListener("default", defaultListener.createListener());
        return serverFactory;
    }
}

