/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.concurrent;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ThreadLocalRandom;
import sun.misc.Unsafe;

class ThreadLocalRandomUtil {
    static final Unsafe UNSAFE = ThreadLocalRandomUtil.getSMU();
    private static final long PROBE;

    ThreadLocalRandomUtil() {
    }

    static Unsafe getSMU() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(() -> {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : k.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    throw new NoSuchFieldError("the Unsafe");
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static final int getProbe() {
        return UNSAFE.getInt(Thread.currentThread(), PROBE);
    }

    static final int advanceProbe(int probe) {
        probe ^= probe << 13;
        probe ^= probe >>> 17;
        probe ^= probe << 5;
        UNSAFE.putInt(Thread.currentThread(), PROBE, probe);
        return probe;
    }

    static final void localInit() {
        ThreadLocalRandom.current();
    }

    static String mapEntryToString(Object key, Object val) {
        String k = ThreadLocalRandomUtil.objectToString(key);
        int klen = k.length();
        String v = ThreadLocalRandomUtil.objectToString(val);
        int vlen = v.length();
        char[] chars = new char[klen + vlen + 1];
        k.getChars(0, klen, chars, 0);
        chars[klen] = 61;
        v.getChars(0, vlen, chars, klen + 1);
        return new String(chars);
    }

    /*
     * WARNING - void declaration
     */
    private static String objectToString(Object x) {
        void var1_1;
        String s;
        return x == null || (s = x.toString()) == null ? "null" : var1_1;
    }

    static {
        try {
            Class<Thread> tk = Thread.class;
            PROBE = UNSAFE.objectFieldOffset(tk.getDeclaredField("threadLocalRandomProbe"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

