/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.jsonschema2pojo.rules;

import org.apache.hadoop.shaded.com.sun.codemodel.JClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JClassContainer;
import org.apache.hadoop.shaded.com.sun.codemodel.JDefinedClass;
import org.apache.hadoop.shaded.com.sun.codemodel.JDocComment;
import org.apache.hadoop.shaded.com.sun.codemodel.JDocCommentable;
import org.apache.hadoop.shaded.com.sun.codemodel.JFieldVar;
import org.apache.hadoop.shaded.com.sun.codemodel.JPackage;
import org.apache.hadoop.shaded.com.sun.codemodel.JType;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Annotator;
import org.apache.hadoop.shaded.org.jsonschema2pojo.DefaultGenerationConfig;
import org.apache.hadoop.shaded.org.jsonschema2pojo.GenerationConfig;
import org.apache.hadoop.shaded.org.jsonschema2pojo.Jackson2Annotator;
import org.apache.hadoop.shaded.org.jsonschema2pojo.RuleLogger;
import org.apache.hadoop.shaded.org.jsonschema2pojo.SchemaStore;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.AdditionalPropertiesRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.ArrayRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.BuilderRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.ConstructorRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.DefaultRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.DescriptionRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.DigitsRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.DynamicPropertiesRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.EnumRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.FormatRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.JavaNameRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.MediaRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.MinItemsMaxItemsRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.MinLengthMaxLengthRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.MinimumMaximumRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.NotRequiredRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.ObjectRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.PatternRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.PropertiesRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.PropertyRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RequiredArrayRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.RequiredRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.Rule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.SchemaRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.TitleRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.TypeRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.rules.ValidRule;
import org.apache.hadoop.shaded.org.jsonschema2pojo.util.NameHelper;
import org.apache.hadoop.shaded.org.jsonschema2pojo.util.ParcelableHelper;
import org.apache.hadoop.shaded.org.jsonschema2pojo.util.ReflectionHelper;

public class RuleFactory {
    private RuleLogger logger;
    private NameHelper nameHelper;
    private ReflectionHelper reflectionHelper;
    private GenerationConfig generationConfig;
    private Annotator annotator;
    private SchemaStore schemaStore;

    public RuleFactory(GenerationConfig generationConfig, Annotator annotator, SchemaStore schemaStore) {
        this.generationConfig = generationConfig;
        this.annotator = annotator;
        this.schemaStore = schemaStore;
        this.nameHelper = new NameHelper(generationConfig);
        this.reflectionHelper = new ReflectionHelper(this);
    }

    public RuleFactory() {
        this(new DefaultGenerationConfig(), new Jackson2Annotator(new DefaultGenerationConfig()), new SchemaStore());
    }

    public Rule<JPackage, JClass> getArrayRule() {
        return new ArrayRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getDescriptionRule() {
        return new DescriptionRule();
    }

    public Rule<JClassContainer, JType> getEnumRule() {
        return new EnumRule(this);
    }

    public Rule<JType, JType> getFormatRule() {
        return new FormatRule(this);
    }

    public Rule<JPackage, JType> getObjectRule() {
        return new ObjectRule(this, new ParcelableHelper(), this.reflectionHelper);
    }

    public Rule<JDefinedClass, JDefinedClass> getConstructorRule() {
        return new ConstructorRule(this, this.reflectionHelper);
    }

    public Rule<JDefinedClass, JDefinedClass> getRequiredArrayRule() {
        return new RequiredArrayRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getPropertiesRule() {
        return new PropertiesRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getPropertyRule() {
        return new PropertyRule(this);
    }

    public Rule<JDocCommentable, JDocCommentable> getRequiredRule() {
        return new RequiredRule(this);
    }

    public Rule<JDocCommentable, JDocCommentable> getNotRequiredRule() {
        return new NotRequiredRule(this);
    }

    public Rule<JClassContainer, JType> getTypeRule() {
        return new TypeRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getAdditionalPropertiesRule() {
        return new AdditionalPropertiesRule(this);
    }

    public Rule<JDocCommentable, JDocComment> getTitleRule() {
        return new TitleRule();
    }

    public Rule<JClassContainer, JType> getSchemaRule() {
        return new SchemaRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getDefaultRule() {
        return new DefaultRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinimumMaximumRule() {
        return new MinimumMaximumRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinItemsMaxItemsRule() {
        return new MinItemsMaxItemsRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getMinLengthMaxLengthRule() {
        return new MinLengthMaxLengthRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getDigitsRule() {
        return new DigitsRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getPatternRule() {
        return new PatternRule(this);
    }

    public Rule<JFieldVar, JFieldVar> getValidRule() {
        return new ValidRule(this);
    }

    public GenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public void setGenerationConfig(GenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
        this.nameHelper = new NameHelper(generationConfig);
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(Annotator annotator) {
        this.annotator = annotator;
    }

    public RuleLogger getLogger() {
        return this.logger;
    }

    public void setLogger(RuleLogger logger) {
        this.logger = logger;
    }

    public SchemaStore getSchemaStore() {
        return this.schemaStore;
    }

    public void setSchemaStore(SchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    public NameHelper getNameHelper() {
        return this.nameHelper;
    }

    public ReflectionHelper getReflectionHelper() {
        return this.reflectionHelper;
    }

    public Rule<JType, JType> getMediaRule() {
        return new MediaRule();
    }

    public Rule<JDefinedClass, JDefinedClass> getDynamicPropertiesRule() {
        return new DynamicPropertiesRule(this);
    }

    public Rule<JDefinedClass, JDefinedClass> getBuilderRule() {
        return new BuilderRule(this, this.reflectionHelper);
    }

    public Rule<JDocCommentable, JDocComment> getJavaNameRule() {
        return new JavaNameRule();
    }
}

