/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.webapp.dao;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogFileInfo;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.webapp.ContainerLogsUtils;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerLogsInfo;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="containerLogsInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NMContainerLogsInfo
extends ContainerLogsInfo {
    public NMContainerLogsInfo() {
    }

    public NMContainerLogsInfo(Context nmContext, ContainerId containerId, String remoteUser, ContainerLogAggregationType logType) throws YarnException {
        this.logType = logType.toString();
        this.containerId = containerId.toString();
        this.nodeId = nmContext.getNodeId().toString();
        this.containerLogsInfo = NMContainerLogsInfo.getContainerLogsInfo(containerId, remoteUser, nmContext);
    }

    private static List<ContainerLogFileInfo> getContainerLogsInfo(ContainerId id, String remoteUser, Context nmContext) throws YarnException {
        ArrayList<ContainerLogFileInfo> logFiles = new ArrayList<ContainerLogFileInfo>();
        List<File> logDirs = ContainerLogsUtils.getContainerLogDirs(id, remoteUser, nmContext);
        for (File containerLogsDir : logDirs) {
            File[] logs = containerLogsDir.listFiles();
            if (logs == null) continue;
            for (File log : logs) {
                if (!log.isFile()) continue;
                ContainerLogFileInfo logMeta = new ContainerLogFileInfo(log.getName(), Long.toString(log.length()), Times.format((long)log.lastModified()));
                logFiles.add(logMeta);
            }
        }
        return logFiles;
    }
}

