/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.hbck1.HBaseFsck;
import org.apache.hbase.hbck1.HFileCorruptionChecker;

public class FileSystemFsck
implements Closeable {
    private final Configuration configuration;
    private FileSystem fs;
    private Path rootDir;

    FileSystemFsck(Configuration conf) throws IOException {
        this.configuration = conf;
        this.rootDir = CommonFSUtils.getRootDir((Configuration)this.configuration);
        this.fs = this.rootDir.getFileSystem(this.configuration);
    }

    @Override
    public void close() {
    }

    int fsck(List<String> tables, boolean fix) throws IOException {
        if (fix && !HBaseFsck.versionFileExists(this.fs, this.rootDir)) {
            HBaseFsck.versionFileCreate(this.configuration, this.fs, this.rootDir);
        }
        try (HBaseFsck hbaseFsck = new HBaseFsck(this.configuration);){
            HFileCorruptionChecker hfcc = hbaseFsck.createHFileCorruptionChecker(fix);
            hbaseFsck.setHFileCorruptionChecker(hfcc);
            List tableDirs = tables.isEmpty() ? FSUtils.getTableDirs((FileSystem)this.fs, (Path)this.rootDir) : (Collection)tables.stream().map(t -> CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)TableName.valueOf((String)t))).collect(Collectors.toList());
            hfcc.checkTables(tableDirs);
            hfcc.report(hbaseFsck.getErrors());
            hbaseFsck.setFixReferenceFiles(fix);
            hbaseFsck.setFixHFileLinks(fix);
            hbaseFsck.setCheckHdfs(true);
            if (!tables.isEmpty()) {
                tables.stream().map(TableName::valueOf).forEach(hbaseFsck::includeTable);
            }
            if (!tableDirs.isEmpty()) {
                tableDirs.forEach(hbaseFsck::includeTableDir);
            }
            hbaseFsck.offlineHbck();
        }
        catch (ClassNotFoundException | InterruptedException e) {
            throw new IOException(e);
        }
        return 0;
    }
}

