/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.FsRegionsMetaRecoverer;
import org.apache.hbase.HBCKMetaEntry;
import org.apache.hbase.RegionInfoMismatchTool;
import org.apache.hbase.Version;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBCK2
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(HBCK2.class);
    private static final int EXIT_SUCCESS = 0;
    static final int EXIT_FAILURE = 1;
    private static final char META_REPLICA_ID_DELIMITER = '_';
    private static final String SET_TABLE_STATE = "setTableState";
    private static final String ASSIGNS = "assigns";
    private static final String UNASSIGNS = "unassigns";
    private static final String BYPASS = "bypass";
    private static final String FILESYSTEM = "filesystem";
    private static final String REPLICATION = "replication";
    private static final String VERSION = "version";
    private static final String SET_REGION_STATE = "setRegionState";
    private static final String SCHEDULE_RECOVERIES = "scheduleRecoveries";
    private static final String RECOVER_UNKNOWN = "recoverUnknown";
    private static final String GENERATE_TABLE_INFO = "generateMissingTableDescriptorFile";
    private static final String FIX_META = "fixMeta";
    private static final String REGIONINFO_MISMATCH = "regionInfoMismatch";
    private static final Map<String, List<String>> FUNCTION_NAME_MAP = Collections.unmodifiableMap(new HashMap<String, List<String>>(){
        {
            this.put(HBCK2.SET_TABLE_STATE, Arrays.asList("setTableStateInMeta"));
            this.put(HBCK2.BYPASS, Arrays.asList("bypassProcedure"));
            this.put(HBCK2.SCHEDULE_RECOVERIES, Arrays.asList("scheduleServerCrashProcedure", "scheduleServerCrashProcedures"));
            this.put(HBCK2.RECOVER_UNKNOWN, Arrays.asList("scheduleSCPsForUnknownServers"));
        }
    });
    private static final String ADD_MISSING_REGIONS_IN_META_FOR_TABLES = "addFsRegionsMissingInMeta";
    private static final String REPORT_MISSING_REGIONS_IN_META = "reportMissingRegionsInMeta";
    private static final String EXTRA_REGIONS_IN_META = "extraRegionsInMeta";
    private Configuration conf;
    static final String[] MINIMUM_HBCK2_VERSION = new String[]{"2.0.3", "2.1.1", "2.2.0", "3.0.0"};
    private boolean skipCheck = false;
    private static final long DEFAULT_LOCK_WAIT = 1L;
    private static final int NO_BATCH_SIZE = -1;
    private static final int DEFAULT_BATCH_SIZE = -1;

    void checkHBCKSupport(Connection connection, String cmd, String ... supportedVersions) throws IOException {
        if (this.skipCheck) {
            LOG.info("Skipped {} command version check; 'skip' set", (Object)cmd);
            return;
        }
        try (Admin admin = connection.getAdmin();){
            String serverVersion = admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.HBASE_VERSION)).getHBaseVersion();
            Object[] thresholdVersions = supportedVersions == null || supportedVersions.length == 0 ? MINIMUM_HBCK2_VERSION : supportedVersions;
            boolean supported = Version.check(serverVersion, (String[])thresholdVersions);
            if (!supported) {
                throw new UnsupportedOperationException(cmd + " not supported on server version=" + serverVersion + "; needs at least a server that matches or exceeds " + Arrays.toString(thresholdVersions));
            }
        }
    }

    void checkFunctionSupported(Connection connection, String cmd) throws IOException {
        if (this.skipCheck) {
            LOG.info("Skipped {} command version check; 'skip' set", (Object)cmd);
            return;
        }
        List<Method> methods = Arrays.asList(connection.getHbck().getClass().getDeclaredMethods());
        List<String> finalCmds = FUNCTION_NAME_MAP.getOrDefault(cmd, Collections.singletonList(cmd));
        boolean supported = methods.stream().anyMatch(method -> finalCmds.contains(method.getName()));
        if (!supported) {
            throw new UnsupportedOperationException("This HBase cluster does not support command: " + cmd);
        }
    }

    public static byte[] getRegionStateColumn(int replicaId) {
        try {
            return replicaId == 0 ? HConstants.STATE_QUALIFIER : ("state_" + String.format("%04X", replicaId)).getBytes(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }

    void setTableState(Hbck hbck, String[] args) throws IOException {
        Options options = new Options();
        Option inputFile = Option.builder((String)"i").longOpt("inputFiles").build();
        options.addOption(inputFile);
        CommandLine commandLine = this.getCommandLine(args, options);
        if (commandLine == null) {
            return;
        }
        String[] argList = commandLine.getArgs();
        if (!commandLine.hasOption(inputFile.getOpt())) {
            System.out.println(this.setTableStateByArgs(hbck, argList));
        } else {
            List<String> inputList = this.getFromArgsOrFiles(this.stringArrayToList(argList), true);
            for (String line : inputList) {
                String[] params = line.split("\\s+");
                System.out.println(this.setTableStateByArgs(hbck, params));
            }
        }
    }

    TableState setTableStateByArgs(Hbck hbck, String[] args) throws IOException {
        if (args == null || args.length < 2) {
            HBCK2.showErrorMessage("setTableState takes tablename and state arguments: e.g. user ENABLED, you entered: " + Arrays.toString(args));
            return null;
        }
        return this.setTableState(hbck, TableName.valueOf((String)args[0]), TableState.State.valueOf((String)args[1]));
    }

    TableState setTableState(Hbck hbck, TableName tableName, TableState.State state) throws IOException {
        return hbck.setTableStateInMeta(new TableState(tableName, state));
    }

    int setRegionState(Connection connection, String region, RegionState.State newState) throws IOException {
        return this.setRegionState(connection, region, 0, newState);
    }

    int setRegionState(Connection connection, String[] args) throws IOException {
        Options options = new Options();
        Option inputFile = Option.builder((String)"i").longOpt("inputFiles").build();
        options.addOption(inputFile);
        CommandLine commandLine = this.getCommandLine(args, options);
        if (commandLine == null) {
            return 1;
        }
        String[] argList = commandLine.getArgs();
        if (argList == null) {
            return 1;
        }
        if (!commandLine.hasOption(inputFile.getOpt())) {
            String[] params = this.formatSetRegionStateCommand(argList);
            return this.setRegionStateByArgs(connection, params);
        }
        List<String> inputList = this.getFromArgsOrFiles(this.stringArrayToList(argList), true);
        for (String line : inputList) {
            String[] params = this.formatSetRegionStateCommand(line.split("\\s+"));
            if (this.setRegionStateByArgs(connection, params) != 1) continue;
            HBCK2.showErrorMessage("setRegionState failed to set " + Arrays.toString(args));
        }
        return 0;
    }

    int setRegionStateByArgs(Connection connection, String[] args) throws IOException {
        if (args == null || args.length < 3) {
            return 1;
        }
        RegionState.State state = RegionState.State.valueOf((String)args[2]);
        int replicaId = Integer.parseInt(args[1]);
        return this.setRegionState(connection, args[0], replicaId, state);
    }

    int setRegionState(Connection connection, String region, int replicaId, RegionState.State newState) throws IOException {
        if (newState == null) {
            throw new IllegalArgumentException("State can't be null.");
        }
        RegionState.State currentState = null;
        Table table = connection.getTable(TableName.valueOf((String)"hbase:meta"));
        RowFilter filter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator(region));
        Scan scan = new Scan();
        scan.setFilter((Filter)filter);
        Result result = table.getScanner(scan).next();
        if (result != null) {
            byte[] currentStateValue = result.getValue(HConstants.CATALOG_FAMILY, HBCK2.getRegionStateColumn(replicaId));
            if (currentStateValue == null) {
                System.out.println("WARN: Region state info on meta was NULL");
            } else {
                currentState = RegionState.State.valueOf((String)Bytes.toString((byte[])currentStateValue));
            }
            Put put = new Put(result.getRow());
            put.addColumn(HConstants.CATALOG_FAMILY, HBCK2.getRegionStateColumn(replicaId), Bytes.toBytes((String)newState.name()));
            table.put(put);
            if (replicaId == 0) {
                System.out.println("Changed region " + region + " STATE from " + currentState + " to " + newState);
            } else {
                System.out.println("Changed STATE for replica reigon " + replicaId + " of primary region " + region + "from " + currentState + " to " + newState);
            }
            return 0;
        }
        System.out.println("ERROR: Could not find region " + region + " in meta.");
        return 1;
    }

    Map<TableName, List<Path>> reportTablesWithMissingRegionsInMeta(String ... args) throws IOException {
        Map<TableName, List<Path>> report;
        try (FsRegionsMetaRecoverer fsRegionsMetaRecoverer = new FsRegionsMetaRecoverer(this.conf);){
            report = fsRegionsMetaRecoverer.reportTablesMissingRegions(this.getInputList(args));
        }
        catch (IOException e) {
            LOG.error("Error reporting missing regions: ", e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.formatMissingRegionsInMetaReport(report));
        }
        return report;
    }

    Map<TableName, List<String>> extraRegionsInMeta(String[] args) throws Exception {
        Options options = new Options();
        Option fixOption = Option.builder((String)"f").longOpt("fix").build();
        options.addOption(fixOption);
        Option inputFile = Option.builder((String)"i").longOpt("inputFiles").build();
        options.addOption(inputFile);
        HashMap<TableName, List<String>> result = new HashMap<TableName, List<String>>();
        CommandLine commandLine = this.getCommandLine(args, options);
        if (commandLine == null) {
            return result;
        }
        boolean fix = commandLine.hasOption(fixOption.getOpt());
        boolean inputFileFlag = commandLine.hasOption(inputFile.getOpt());
        try (FsRegionsMetaRecoverer fsRegionsMetaRecoverer = new FsRegionsMetaRecoverer(this.conf);){
            List<Future<List<String>>> removeResult;
            List<String> namespacesTables = this.getFromArgsOrFiles(commandLine.getArgList(), inputFileFlag);
            Map<TableName, List<HBCKMetaEntry>> reportMap = fsRegionsMetaRecoverer.reportTablesExtraRegions(namespacesTables);
            ArrayList<String> toFix = new ArrayList<String>();
            reportMap.entrySet().forEach(e -> {
                result.put((TableName)e.getKey(), ((List)e.getValue()).stream().map(r -> r.getEncodedRegionName()).collect(Collectors.toList()));
                if (fix && ((List)e.getValue()).size() > 0) {
                    toFix.add(((TableName)e.getKey()).getNameWithNamespaceInclAsString());
                }
            });
            if (fix && (removeResult = fsRegionsMetaRecoverer.removeExtraRegionsFromMetaForTables(toFix)) != null) {
                int totalRegions = 0;
                ArrayList<Exception> errors = new ArrayList<Exception>();
                for (Future<List<String>> f : removeResult) {
                    try {
                        totalRegions += f.get().size();
                    }
                    catch (InterruptedException | ExecutionException e2) {
                        errors.add(e2);
                    }
                }
                System.out.println(this.formatRemovedRegionsMessage(totalRegions, errors));
            }
        }
        catch (IOException e3) {
            LOG.error("Error on checking extra regions: ", e3);
            throw e3;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.formatExtraRegionsReport(result));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Future<List<String>>> addMissingRegionsInMetaForTables(String ... nameSpaceOrTable) throws IOException {
        try (FsRegionsMetaRecoverer fsRegionsMetaRecoverer = new FsRegionsMetaRecoverer(this.conf);){
            List<Future<List<String>>> list = fsRegionsMetaRecoverer.addMissingRegionsInMetaForTables(this.getInputList(nameSpaceOrTable));
            return list;
        }
        catch (IOException e) {
            LOG.error("Error adding missing regions: ", e);
            throw e;
        }
    }

    private Pair<List<String>, List<Exception>> addMissingRegionsInMetaForTablesWrapper(String ... args) throws IOException {
        Options options = new Options();
        Option outputFile = Option.builder((String)"o").longOpt("outputFile").hasArg().build();
        options.addOption(outputFile);
        Option numberOfLinesPerFile = Option.builder((String)"n").longOpt("numLines").hasArg().build();
        options.addOption(numberOfLinesPerFile);
        Option inputFile = Option.builder((String)"i").longOpt("inputFiles").build();
        options.addOption(inputFile);
        Pair result = Pair.newPair(new ArrayList(), new ArrayList());
        List regionsList = (List)result.getFirst();
        List errorList = (List)result.getSecond();
        CommandLine commandLine = this.getCommandLine(args, options);
        if (commandLine == null) {
            return result;
        }
        boolean outputFileFlag = commandLine.hasOption(outputFile.getOpt());
        boolean inputFileFlag = commandLine.hasOption(inputFile.getOpt());
        boolean numberOfLinesPerFileFlag = commandLine.hasOption(numberOfLinesPerFile.getOpt());
        List<String> namespacesTables = this.getFromArgsOrFiles(commandLine.getArgList(), inputFileFlag);
        List<Future<List<String>>> addedRegions = this.addMissingRegionsInMetaForTables(namespacesTables.toArray(new String[0]));
        for (Future<List<String>> f : addedRegions) {
            try {
                regionsList.addAll((Collection)f.get());
            }
            catch (InterruptedException | ExecutionException e) {
                errorList.add(e);
            }
        }
        if (outputFileFlag) {
            String fileNameOrPrefix = commandLine.getOptionValue(outputFile.getOpt());
            if (numberOfLinesPerFileFlag) {
                int numberOfRegionsPerFile = Integer.parseInt(commandLine.getOptionValue(numberOfLinesPerFile.getOpt()));
                List partition = Lists.partition((List)regionsList, (int)numberOfRegionsPerFile);
                for (int i = 0; i < partition.size(); ++i) {
                    File file = new File(fileNameOrPrefix + "." + i);
                    System.out.println("Dumping region names to file: " + file.getAbsolutePath());
                    FileUtils.writeLines((File)file, (Collection)((Collection)partition.get(i)));
                }
            } else {
                File file = new File(fileNameOrPrefix);
                System.out.println("Dumping region names to file: " + file.getAbsolutePath());
                FileUtils.writeLines((File)file, (Collection)regionsList);
            }
        }
        return result;
    }

    List<Long> assigns(Hbck hbck, String[] args) throws IOException {
        Options options = new Options();
        Option override = Option.builder((String)"o").longOpt("override").build();
        Option inputFile = Option.builder((String)"i").longOpt("inputFiles").build();
        Option batchOpt = Option.builder((String)"b").longOpt("batchSize").hasArg().type(Integer.class).build();
        options.addOption(override);
        options.addOption(inputFile);
        options.addOption(batchOpt);
        CommandLine commandLine = this.getCommandLine(args, options);
        if (commandLine == null) {
            return null;
        }
        int batchSize = HBCK2.getBatchSize(batchOpt, commandLine);
        boolean overrideFlag = commandLine.hasOption(override.getOpt());
        boolean inputFileFlag = commandLine.hasOption(inputFile.getOpt());
        List<String> regionList = this.getFromArgsOrFiles(commandLine.getArgList(), inputFileFlag);
        if (batchSize == -1) {
            return hbck.assigns(regionList, overrideFlag);
        }
        ArrayList<Long> pidList = new ArrayList<Long>(regionList.size());
        List batch = Lists.partition(regionList, (int)batchSize);
        for (int i = 0; i < batch.size(); ++i) {
            LOG.info("Processing batch #{}", (Object)(i + 1));
            pidList.addAll(hbck.assigns((List)batch.get(i), overrideFlag));
        }
        return pidList;
    }

    List<Long> unassigns(Hbck hbck, String[] args) throws IOException {
        Options options = new Options();
        Option override = Option.builder((String)"o").longOpt("override").build();
        Option inputFile = Option.builder((String)"i").longOpt("inputFiles").build();
        Option batchOpt = Option.builder((String)"b").longOpt("batchSize").hasArg().type(Integer.class).build();
        options.addOption(override);
        options.addOption(inputFile);
        options.addOption(batchOpt);
        CommandLine commandLine = this.getCommandLine(args, options);
        if (commandLine == null) {
            return null;
        }
        boolean overrideFlag = commandLine.hasOption(override.getOpt());
        boolean inputFileFlag = commandLine.hasOption(inputFile.getOpt());
        int batchSize = HBCK2.getBatchSize(batchOpt, commandLine);
        List<String> regionList = this.getFromArgsOrFiles(commandLine.getArgList(), inputFileFlag);
        if (batchSize == -1) {
            return hbck.unassigns(regionList, overrideFlag);
        }
        ArrayList<Long> pidList = new ArrayList<Long>(regionList.size());
        List batch = Lists.partition(regionList, (int)batchSize);
        for (int i = 0; i < batch.size(); ++i) {
            LOG.info("Processing batch #{}", (Object)(i + 1));
            pidList.addAll(hbck.unassigns((List)batch.get(i), overrideFlag));
        }
        return pidList;
    }

    /*
     * Exception decompiling
     */
    List<Boolean> bypass(String[] args) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    List<Long> scheduleRecoveries(Hbck hbck, String[] args) throws IOException {
        ArrayList<ServerName> serverNames = new ArrayList<ServerName>();
        List<String> inputList = this.getInputList(args);
        if (inputList != null) {
            for (String serverName : inputList) {
                serverNames.add(ServerName.parseServerName((String)serverName));
            }
        }
        try {
            return hbck.scheduleServerCrashProcedures(serverNames);
        }
        catch (NoSuchMethodError | UnsupportedOperationException e) {
            LOG.warn("scheduleServerCrashProcedures not supported, falling back to scheduleServerCrashProcedure");
            return this.scheduleRecoveriesDeprecated(hbck, inputList);
        }
    }

    private List<Long> scheduleRecoveriesDeprecated(Hbck hbck, List<String> inputList) throws IOException {
        try {
            ArrayList<HBaseProtos.ServerName> protoServerNames = new ArrayList<HBaseProtos.ServerName>();
            if (inputList != null) {
                for (String serverName : inputList) {
                    protoServerNames.add(this.parseServerName(serverName));
                }
            }
            Method method = hbck.getClass().getMethod("scheduleServerCrashProcedure", List.class);
            return (List)method.invoke((Object)hbck, protoServerNames);
        }
        catch (Exception ex) {
            throw new IOException("This HBase cluster does not support scheduleRecoveries command", ex);
        }
    }

    List<Long> recoverUnknown(Hbck hbck) throws IOException {
        return hbck.scheduleSCPsForUnknownServers();
    }

    void regionInfoMismatch(String[] args) throws Exception {
        Options options = new Options();
        Option dryRunOption = Option.builder((String)"f").longOpt("fix").hasArg(false).build();
        options.addOption(dryRunOption);
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(options, args, false);
        boolean fix = commandLine.hasOption(dryRunOption.getOpt());
        try (Connection connection = this.connect();){
            new RegionInfoMismatchTool(connection).run(fix);
        }
    }

    private HBaseProtos.ServerName parseServerName(String serverName) {
        ServerName sn = ServerName.parseServerName((String)serverName);
        return HBaseProtos.ServerName.newBuilder().setHostName(sn.getHostname()).setPort(sn.getPort()).setStartCode(sn.getStartcode()).build();
    }

    private String readHBCK2BuildProperties(String propertyKey) throws IOException {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("hbck2.properties");
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties.getProperty(propertyKey);
    }

    private static String getCommandUsage() {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        writer.println("Command:");
        HBCK2.usageAddFsRegionsMissingInMeta(writer);
        writer.println();
        HBCK2.usageAssigns(writer);
        writer.println();
        HBCK2.usageBypass(writer);
        writer.println();
        HBCK2.usageExtraRegionsInMeta(writer);
        writer.println();
        HBCK2.usageFilesystem(writer);
        writer.println();
        HBCK2.usageFixMeta(writer);
        writer.println();
        HBCK2.usageGenerateMissingTableInfo(writer);
        writer.println();
        HBCK2.usageRecoverUnknown(writer);
        writer.println();
        HBCK2.usageRegioninfoMismatch(writer);
        writer.println();
        HBCK2.usageReplication(writer);
        writer.println();
        HBCK2.usageReportMissingRegionsInMeta(writer);
        writer.println();
        HBCK2.usageSetRegionState(writer);
        writer.println();
        HBCK2.usageSetTableState(writer);
        writer.println();
        HBCK2.usageScheduleRecoveries(writer);
        writer.println();
        HBCK2.usageUnassigns(writer);
        writer.println();
        writer.close();
        return sw.toString();
    }

    private static void usageAddFsRegionsMissingInMeta(PrintWriter writer) {
        writer.println(" addFsRegionsMissingInMeta [OPTIONS]");
        writer.println("      [<NAMESPACE|NAMESPACE:TABLENAME>...|-i <INPUTFILES>...]");
        writer.println("   Options:");
        writer.println("    -i,--inputFiles  take one or more files of namespace or table names");
        writer.println("    -o,--outputFile  name/prefix of the file(s) to dump region names");
        writer.println("    -n,--numLines  number of lines to be written to each output file");
        writer.println("   To be used when regions missing from hbase:meta but directories");
        writer.println("   are present still in HDFS. Can happen if user has run _hbck1_");
        writer.println("   'OfflineMetaRepair' against an hbase-2.x cluster. Needs hbase:meta");
        writer.println("   to be online. For each table name passed as parameter, performs diff");
        writer.println("   between regions available in hbase:meta and region dirs on HDFS.");
        writer.println("   Then for dirs with no hbase:meta matches, it reads the 'regioninfo'");
        writer.println("   metadata file and re-creates given region in hbase:meta. Regions are");
        writer.println("   re-created in 'CLOSED' state in the hbase:meta table, but not in the");
        writer.println("   Masters' cache, and they are not assigned either. To get these");
        writer.println("   regions online, run the HBCK2 'assigns'command printed when this");
        writer.println("   command-run completes.");
        writer.println("   NOTE: If using hbase releases older than 2.3.0, a rolling restart of");
        writer.println("   HMasters is needed prior to executing the set of 'assigns' output.");
        writer.println("   An example adding missing regions for tables 'tbl_1' in the default");
        writer.println("   namespace, 'tbl_2' in namespace 'n1' and for all tables from");
        writer.println("   namespace 'n2':");
        writer.println("     $ HBCK2 addFsRegionsMissingInMeta default:tbl_1 n1:tbl_2 n2");
        writer.println("   Returns HBCK2  an 'assigns' command with all re-inserted regions.");
        writer.println("   SEE ALSO: reportMissingRegionsInMeta");
        writer.println("   SEE ALSO: fixMeta");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains <NAMESPACE|NAMESPACE:TABLENAME>, one per line.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 addFsRegionsMissingInMeta -i fileName1 fileName2");
        writer.println("   If -o or --outputFile is specified, the output file(s) can be passed as");
        writer.println("    input to assigns command via -i or -inputFiles option.");
        writer.println("   If -n or --numLines is specified, and say it is  set to 100, this will");
        writer.println("   create files with prefix as value passed by -o or --outputFile option.");
        writer.println("   Each file will have 100 region names (max.), one per line.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 addFsRegionsMissingInMeta -o outputFilePrefix -n 100");
        writer.println("     -i fileName1 fileName2");
        writer.println("   But if -n is not specified, but -o is specified, it will dump all");
        writer.println("   region names in a single file, one per line.");
        writer.println("   NOTE: -n option is applicable only if -o option is specified.");
    }

    private static void usageAssigns(PrintWriter writer) {
        writer.println(" assigns [OPTIONS] [<ENCODED_REGIONNAME>...|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -o,--override  override ownership by another procedure");
        writer.println("    -i,--inputFiles  take one or more files of encoded region names");
        writer.println("    -b,--batchSize   number of regions to process in a batch");
        writer.println("   A 'raw' assign that can be used even during Master initialization (if");
        writer.println("   the -skip flag is specified). Skirts Coprocessors. Pass one or more");
        writer.println("   encoded region names. 1588230740 is the hard-coded name for the");
        writer.println("   hbase:meta region and de00010733901a05f5a2a3a382e27dd4 is an example of");
        writer.println("   what a user-space encoded region name looks like. For example:");
        writer.println("     $ HBCK2 assigns 1588230740 de00010733901a05f5a2a3a382e27dd4");
        writer.println("   Returns the pid(s) of the created AssignProcedure(s) or -1 if none.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains encoded region names, one per line. For example:");
        writer.println("     $ HBCK2 assigns -i fileName1 fileName2");
        writer.println("   If -b or --batchSize is specified, the command processes those many");
        writer.println("   regions at a time in a batch-ed manner; Consider using this option,");
        writer.println("   if the list of regions is huge, to avoid CallTimeoutException.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 assigns -i fileName1 fileName2 -b 500");
        writer.println("   By default, batchSize is set to -1 i.e. no batching is done.");
    }

    private static void usageBypass(PrintWriter writer) {
        writer.println(" bypass [OPTIONS] [<PID>...|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -o,--override   override if procedure is running/stuck");
        writer.println("    -r,--recursive  bypass parent and its children. SLOW! EXPENSIVE!");
        writer.println("    -w,--lockWait   milliseconds to wait before giving up; default=1");
        writer.println("    -i,--inputFiles  take one or more input files of PID's");
        writer.println("    -b,--batchSize   number of procedures to process in a batch");
        writer.println("   Pass one (or more) procedure 'pid's to skip to procedure finish. Parent");
        writer.println("   of bypassed procedure will also be skipped to the finish. Entities will");
        writer.println("   be left in an inconsistent state and will require manual fixup. May");
        writer.println("   need Master restart to clear locks still held. Bypass fails if");
        writer.println("   procedure has children. Add 'recursive' if all you have is a parent pid");
        writer.println("   to finish parent and children. This is SLOW, and dangerous so use");
        writer.println("   selectively. Does not always work.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains PID's, one per line. For example:");
        writer.println("     $ HBCK2 bypass -i fileName1 fileName2");
        writer.println("   If -b or --batchSize is specified, the command processes those many");
        writer.println("   procedures at a time in a batch-ed manner; Consider using this option,");
        writer.println("   if the list of procedures is huge, to avoid CallTimeoutException.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 bypass -i fileName1 fileName2 -b 500");
        writer.println("   By default, batchSize is set to -1 i.e. no batching is done.");
    }

    private static void usageFilesystem(PrintWriter writer) {
        writer.println(" filesystem [OPTIONS] [<TABLENAME>...|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -f, --fix    sideline corrupt hfiles, bad links, and references.");
        writer.println("    -i,--inputFiles  take one or more input files of table names");
        writer.println("   Report on corrupt hfiles, references, broken links, and integrity.");
        writer.println("   Pass '--fix' to sideline corrupt files and links. '--fix' does NOT");
        writer.println("   fix integrity issues; i.e. 'holes' or 'orphan' regions. Pass one or");
        writer.println("   more tablenames to narrow checkup. Default checks all tables and");
        writer.println("   restores 'hbase.version' if missing. Interacts with the filesystem");
        writer.println("   only! Modified regions need to be reopened to pick-up changes.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains table names, one per line. For example:");
        writer.println("     $ HBCK2 filesystem -i fileName1 fileName2");
    }

    private static void usageFixMeta(PrintWriter writer) {
        writer.println(" fixMeta");
        writer.println("   Do a server-side fix of bad or inconsistent state in hbase:meta.");
        writer.println("   Available in hbase 2.2.1/2.1.6 or newer versions. Master UI has");
        writer.println("   matching, new 'HBCK Report' tab that dumps reports generated by");
        writer.println("   most recent run of _catalogjanitor_ and a new 'HBCK Chore'. It");
        writer.println("   is critical that hbase:meta first be made healthy before making");
        writer.println("   any other repairs. Fixes 'holes', 'overlaps', etc., creating");
        writer.println("   (empty) region directories in HDFS to match regions added to");
        writer.println("   hbase:meta. Command is NOT the same as the old _hbck1_ command");
        writer.println("   named similarily. Works against the reports generated by the last");
        writer.println("   catalog_janitor and hbck chore runs. If nothing to fix, run is a");
        writer.println("   noop. Otherwise, if 'HBCK Report' UI reports problems, a run of");
        writer.println("   fixMeta will clear up hbase:meta issues. See 'HBase HBCK' UI");
        writer.println("   for how to generate new report.");
        writer.println("   SEE ALSO: reportMissingRegionsInMeta");
    }

    private static void usageGenerateMissingTableInfo(PrintWriter writer) {
        writer.println(" generateMissingTableDescriptorFile [OPTIONS] [<TABLENAME>...]");
        writer.println("   Trying to fix an orphan table by generating a missing table descriptor");
        writer.println("   file. This command will have no effect if the table folder is missing");
        writer.println("   or if the .tableinfo is present (we don't override existing table");
        writer.println("   descriptors). This command will first check it the TableDescriptor is");
        writer.println("   cached in HBase Master in which case it will recover the .tableinfo");
        writer.println("   accordingly. If TableDescriptor is not cached in master then it will");
        writer.println("   create a default .tableinfo file with the following items:");
        writer.println("     - the table name");
        writer.println("     - the column family list determined based on the file system");
        writer.println("     - the default properties for both TableDescriptor and");
        writer.println("       ColumnFamilyDescriptors");
        writer.println("   If the .tableinfo file was generated using default parameters then");
        writer.println("   make sure you check the table / column family properties later (and");
        writer.println("   change them if needed).");
        writer.println("   This method does not change anything in HBase, only writes the new");
        writer.println("   .tableinfo file to the file system. Orphan tables can cause e.g.");
        writer.println("   ServerCrashProcedures to stuck, you might need to fix these still");
        writer.println("   after you generated the missing table info files. If no tables are ");
        writer.println("   specified, .tableinfo will be generated for all missing table ");
        writer.println("   descriptors.");
    }

    private static void usageReplication(PrintWriter writer) {
        writer.println(" replication [OPTIONS] [<TABLENAME>...|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -f, --fix    fix any replication issues found.");
        writer.println("    -i,--inputFiles  take one or more input files of table names");
        writer.println("   Looks for undeleted replication queues and deletes them if passed the");
        writer.println("   '--fix' option. Pass a table name to check for replication barrier and");
        writer.println("   purge if '--fix'.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains <TABLENAME>, one per line. For example:");
        writer.println("     $ HBCK2 replication -i fileName1 fileName2");
    }

    private static void usageExtraRegionsInMeta(PrintWriter writer) {
        writer.println(" extraRegionsInMeta [<NAMESPACE|NAMESPACE:TABLENAME>...|");
        writer.println("      -i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -f, --fix    fix meta by removing all extra regions found.");
        writer.println("    -i,--inputFiles  take one or more input files of namespace or");
        writer.println("   table names");
        writer.println("   Reports regions present on hbase:meta, but with no related ");
        writer.println("   directories on the file system. Needs hbase:meta to be online. ");
        writer.println("   For each table name passed as parameter, performs diff");
        writer.println("   between regions available in hbase:meta and region dirs on the given");
        writer.println("   file system. Extra regions would get deleted from Meta ");
        writer.println("   if passed the --fix option. ");
        writer.println("   NOTE: Before deciding on use the \"--fix\" option, it's worth check if");
        writer.println("   reported extra regions are overlapping with existing valid regions.");
        writer.println("   If so, then \"extraRegionsInMeta --fix\" is indeed the optimal solution. ");
        writer.println("   Otherwise, \"assigns\" command is the simpler solution, as it recreates ");
        writer.println("   regions dirs in the filesystem, if not existing.");
        writer.println("   An example triggering extra regions report for tables 'table_1'");
        writer.println("   and 'table_2', under default namespace:");
        writer.println("     $ HBCK2 extraRegionsInMeta default:table_1 default:table_2");
        writer.println("   An example triggering extra regions report for table 'table_1'");
        writer.println("   under default namespace, and for all tables from namespace 'ns1':");
        writer.println("     $ HBCK2 extraRegionsInMeta default:table_1 ns1");
        writer.println("   Returns list of extra regions for each table passed as parameter, or");
        writer.println("   for each table on namespaces specified as parameter.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains <NAMESPACE|NAMESPACE:TABLENAME>, one per line.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 extraRegionsInMeta -i fileName1 fileName2");
    }

    private static void usageReportMissingRegionsInMeta(PrintWriter writer) {
        writer.println(" reportMissingRegionsInMeta [<NAMESPACE|NAMESPACE:TABLENAME>...|");
        writer.println("      -i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -i,--inputFiles  take one or more files of namespace or table names");
        writer.println("   To be used when regions missing from hbase:meta but directories");
        writer.println("   are present still in HDFS. Can happen if user has run _hbck1_");
        writer.println("   'OfflineMetaRepair' against an hbase-2.x cluster. This is a CHECK only");
        writer.println("   method, designed for reporting purposes and doesn't perform any");
        writer.println("   fixes, providing a view of which regions (if any) would get re-added");
        writer.println("   to hbase:meta, grouped by respective table/namespace. To effectively");
        writer.println("   re-add regions in meta, run addFsRegionsMissingInMeta.");
        writer.println("   This command needs hbase:meta to be online. For each namespace/table");
        writer.println("   passed as parameter, it performs a diff between regions available in");
        writer.println("   hbase:meta against existing regions dirs on HDFS. Region dirs with no");
        writer.println("   matches are printed grouped under its related table name. Tables with");
        writer.println("   no missing regions will show a 'no missing regions' message. If no");
        writer.println("   namespace or table is specified, it will verify all existing regions.");
        writer.println("   It accepts a combination of multiple namespace and tables. Table names");
        writer.println("   should include the namespace portion, even for tables in the default");
        writer.println("   namespace, otherwise it will assume as a namespace value.");
        writer.println("   An example triggering missing regions report for tables 'table_1'");
        writer.println("   and 'table_2', under default namespace:");
        writer.println("     $ HBCK2 reportMissingRegionsInMeta default:table_1 default:table_2");
        writer.println("   An example triggering missing regions report for table 'table_1'");
        writer.println("   under default namespace, and for all tables from namespace 'ns1':");
        writer.println("     $ HBCK2 reportMissingRegionsInMeta default:table_1 ns1");
        writer.println("   Returns list of missing regions for each table passed as parameter, or");
        writer.println("   for each table on namespaces specified as parameter.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains <NAMESPACE|NAMESPACE:TABLENAME>, one per line.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 reportMissingRegionsInMeta -i fileName1 fileName2");
    }

    private static void usageSetRegionState(PrintWriter writer) {
        writer.println(" setRegionState [<ENCODED_REGIONNAME> <STATE>|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -i,--inputFiles  take one or more input files of encoded region names ");
        writer.println("   and states.");
        writer.println("   To set the replica region's state, it needs the primary region's ");
        writer.println("   encoded regionname and replica id. The command will be ");
        writer.println("   setRegionState <PRIMARY_ENCODED_REGIONNAME>,<replicaId> <STATE>");
        writer.println("   Possible region states:");
        writer.println("    OFFLINE, OPENING, OPEN, CLOSING, CLOSED, SPLITTING, SPLIT,");
        writer.println("    FAILED_OPEN, FAILED_CLOSE, MERGING, MERGED, SPLITTING_NEW,");
        writer.println("    MERGING_NEW, ABNORMALLY_CLOSED");
        writer.println("   WARNING: This is a very risky option intended for use as last resort.");
        writer.println("   Example scenarios include unassigns/assigns that can't move forward");
        writer.println("   because region is in an inconsistent state in 'hbase:meta'. For");
        writer.println("   example, the 'unassigns' command can only proceed if passed a region");
        writer.println("   in one of the following states: SPLITTING|SPLIT|MERGING|OPEN|CLOSING");
        writer.println("   Before manually setting a region state with this command, please");
        writer.println("   certify that this region is not being handled by a running procedure,");
        writer.println("   such as 'assign' or 'split'. You can get a view of running procedures");
        writer.println("   in the hbase shell using the 'list_procedures' command. An example");
        writer.println("   setting region 'de00010733901a05f5a2a3a382e27dd4' to CLOSING:");
        writer.println("     $ HBCK2 setRegionState de00010733901a05f5a2a3a382e27dd4 CLOSING");
        writer.println("   Returns \"0\" if region state changed and \"1\" otherwise.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains <ENCODED_REGIONNAME> <STATE>, one pair per line.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 setRegionState -i fileName1 fileName2");
    }

    private static void usageSetTableState(PrintWriter writer) {
        writer.println(" setTableState [<TABLENAME> <STATE>|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -i,--inputFiles  take one or more files of table names and states");
        writer.println("   Possible table states: " + Arrays.stream(TableState.State.values()).map(Enum::toString).collect(Collectors.joining(", ")));
        writer.println("   To read current table state, in the hbase shell run:");
        writer.println("     hbase> get 'hbase:meta', '<TABLENAME>', 'table:state'");
        writer.println("   A value of \\x08\\x00 == ENABLED, \\x08\\x01 == DISABLED, etc.");
        writer.println("   Can also run a 'describe \"<TABLENAME>\"' at the shell prompt.");
        writer.println("   An example making table name 'user' ENABLED:");
        writer.println("     $ HBCK2 setTableState users ENABLED");
        writer.println("   Returns whatever the previous table state was.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains <TABLENAME> <STATE>, one pair per line.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 setTableState -i fileName1 fileName2");
    }

    private static void usageScheduleRecoveries(PrintWriter writer) {
        writer.println(" scheduleRecoveries [<SERVERNAME>...|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -i,--inputFiles  take one or more input files of server names");
        writer.println("   Schedule ServerCrashProcedure(SCP) for list of RegionServers. Format");
        writer.println("   server name as '<HOSTNAME>,<PORT>,<STARTCODE>' (See HBase UI/logs).");
        writer.println("   Example using RegionServer 'a.example.org,29100,1540348649479':");
        writer.println("     $ HBCK2 scheduleRecoveries a.example.org,29100,1540348649479");
        writer.println("   Returns the pid(s) of the created ServerCrashProcedure(s) or -1 if");
        writer.println("   no procedure created (see master logs for why not).");
        writer.println("   Command support added in hbase versions 2.0.3, 2.1.2, 2.2.0 or newer.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains <SERVERNAME>, one per line. For example:");
        writer.println("     $ HBCK2 scheduleRecoveries -i fileName1 fileName2");
    }

    private static void usageRecoverUnknown(PrintWriter writer) {
        writer.println(" recoverUnknown");
        writer.println("   Schedule ServerCrashProcedure(SCP) for RegionServers that are reported");
        writer.println("   as unknown.");
        writer.println("   Returns the pid(s) of the created ServerCrashProcedure(s) or -1 if");
        writer.println("   no procedure created (see master logs for why not).");
        writer.println("   Command support added in hbase versions 2.2.7, 2.3.5, 2.4.3,");
        writer.println("     2.5.0 or newer.");
    }

    private static void usageUnassigns(PrintWriter writer) {
        writer.println(" unassigns [OPTIONS] [<ENCODED_REGIONNAME>...|-i <INPUT_FILE>...]");
        writer.println("   Options:");
        writer.println("    -o,--override  override ownership by another procedure");
        writer.println("    -i,--inputFiles  take one or more input files of encoded region names");
        writer.println("    -b,--batchSize   number of regions to process in a batch");
        writer.println("   A 'raw' unassign that can be used even during Master initialization");
        writer.println("   (if the -skip flag is specified). Skirts Coprocessors. Pass one or");
        writer.println("   more encoded region names. 1588230740 is the hard-coded name for the");
        writer.println("   hbase:meta region and de00010733901a05f5a2a3a382e27dd4 is an example");
        writer.println("   of what a userspace encoded region name looks like. For example:");
        writer.println("     $ HBCK2 unassigns 1588230740 de00010733901a05f5a2a3a382e27dd4");
        writer.println("   Returns the pid(s) of the created UnassignProcedure(s) or -1 if none.");
        writer.println();
        writer.println("   SEE ALSO, org.apache.hbase.hbck1.OfflineMetaRepair, the offline");
        writer.println("   hbase:meta tool. See the HBCK2 README for how to use.");
        writer.println("   If -i or --inputFiles is specified, pass one or more input file names.");
        writer.println("   Each file contains encoded region names, one per line. For example:");
        writer.println("     $ HBCK2 unassigns -i fileName1 fileName2");
        writer.println("   If -b or --batchSize is specified, the tool processes those many");
        writer.println("   regions at a time in a batch-ed manner; Consider using this option,");
        writer.println("   if the list of regions is huge, to avoid CallTimeoutException.");
        writer.println("   For example:");
        writer.println("     $ HBCK2 unassigns -i fileName1 fileName2 -b 500");
        writer.println("   By default, batchSize is set to -1 i.e. no batching is done.");
    }

    private static void usageRegioninfoMismatch(PrintWriter writer) {
        writer.println(" regionInfoMismatch");
        writer.println("   Options:");
        writer.println("   -f,--fix Update hbase:meta with the corrections");
        writer.println("   It is recommended to first run this utility without the fix");
        writer.println("   option to ensure that the utility is generating the correct");
        writer.println("   serialized RegionInfo data structures. Inspect the output to");
        writer.println("   confirm that the hbase:meta rowkey matches the new RegionInfo.");
        writer.println();
        writer.println("   This tool will read hbase:meta and report any regions whose rowkey");
        writer.println("   and cell value differ in their encoded region name. HBASE-23328 ");
        writer.println("   illustrates a problem for read-replica enabled tables in which ");
        writer.println("   the encoded region name (the MD5 hash) does not match between ");
        writer.println("   the rowkey and the value. This problem is generally harmless ");
        writer.println("   for normal operation, but can break other HBCK2 tools.");
        writer.println();
        writer.println("   Run this command to determine if any regions are affected by ");
        writer.println("   this bug and use the -f/--fix option to then correct any");
        writer.println("   affected regions.");
    }

    static void showErrorMessage(String error) {
        if (error != null) {
            System.out.println("ERROR: " + error);
            System.out.println("FOR USAGE, use the -h or --help option");
        }
    }

    static void showUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("HBCK2 [OPTIONS] COMMAND <ARGS>", "Options:", options, HBCK2.getCommandUsage());
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int run(String[] args) throws IOException {
        String optionValue;
        CommandLine commandLine;
        Options options = new Options();
        Option help = Option.builder((String)"h").longOpt("help").desc("output this help message").build();
        options.addOption(help);
        Option debug = Option.builder((String)"d").longOpt("debug").desc("run with debug output").build();
        options.addOption(debug);
        Option quorum = Option.builder((String)"q").longOpt("hbase.zookeeper.quorum").hasArg().desc("hbase ensemble").build();
        options.addOption(quorum);
        Option parent = Option.builder((String)"z").longOpt("zookeeper.znode.parent").hasArg().desc("parent znode of hbase ensemble").build();
        options.addOption(parent);
        Option peerPort = Option.builder((String)"p").longOpt("hbase.zookeeper.property.clientPort").hasArg().desc("port of hbase ensemble").type(Integer.class).build();
        options.addOption(peerPort);
        Option version = Option.builder((String)"v").longOpt(VERSION).desc("this hbck2 version").build();
        options.addOption(version);
        Option skip = Option.builder((String)"s").longOpt("skip").desc("skip hbase version check (PleaseHoldException)").build();
        options.addOption(skip);
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args, true);
        }
        catch (ParseException e) {
            HBCK2.showErrorMessage(e.getMessage());
            return 1;
        }
        if (commandLine.hasOption(version.getOpt())) {
            System.out.println(this.readHBCK2BuildProperties(VERSION));
            return 0;
        }
        if (commandLine.hasOption(help.getOpt()) || commandLine.getArgList().isEmpty()) {
            HBCK2.showUsage(options);
            return 0;
        }
        if (commandLine.hasOption(debug.getOpt())) {
            Configurator.setRootLevel(Level.DEBUG);
        }
        if (commandLine.hasOption(quorum.getOpt())) {
            this.getConf().set("hbase.zookeeper.quorum", commandLine.getOptionValue(quorum.getOpt()));
        }
        if (commandLine.hasOption(peerPort.getOpt())) {
            optionValue = commandLine.getOptionValue(peerPort.getOpt());
            if (optionValue.matches("[0-9]+")) {
                this.getConf().setInt("hbase.zookeeper.property.clientPort", Integer.parseInt(optionValue));
            } else {
                HBCK2.showErrorMessage("Invalid client port. Please provide proper port for target hbase ensemble.");
                return 1;
            }
        }
        if (commandLine.hasOption(parent.getOpt())) {
            optionValue = commandLine.getOptionValue(parent.getOpt());
            if (optionValue.startsWith("/")) {
                this.getConf().set("zookeeper.znode.parent", optionValue);
            } else {
                HBCK2.showErrorMessage("Invalid parent znode. Please provide proper parent znode of target hbase. Note that valid znodes must start with \"/\".");
                return 1;
            }
        }
        if (commandLine.hasOption(skip.getOpt())) {
            this.skipCheck = true;
        }
        return this.doCommandLine(commandLine, options);
    }

    Connection connect() throws IOException {
        return ConnectionFactory.createConnection((Configuration)this.getConf());
    }

    /*
     * Exception decompiling
     */
    private int doCommandLine(CommandLine commandLine, Options options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static int showUsagePerCommand(String command, Options options) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String toString(List<?> things) {
        return things.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private String formatMissingRegionsInMetaReport(Map<TableName, List<Path>> report) {
        Function<Path, String> resolver = r -> r.getName();
        String message = "Missing Regions for each table:\n\t";
        return this.formatReportMessage(message, (HashMap)report, resolver);
    }

    private String formatExtraRegionsReport(Map<TableName, List<String>> report) {
        String message = "Regions in Meta but having no equivalent dir, for each table:\n\t";
        return this.formatReportMessage(message, (HashMap)report, s -> s);
    }

    private String formatReportMessage(String reportMessage, Map<TableName, List<?>> report, Function resolver) {
        StringBuilder builder = new StringBuilder();
        if (report.size() < 1) {
            builder.append("\nNo reports were found. You are likely passing non-existent namespace or table. Note that table names should include the namespace portion even for tables in the default namespace. See also the command usage.\n");
            return builder.toString();
        }
        builder.append(reportMessage);
        report.keySet().forEach(table -> {
            builder.append(table);
            if (!((List)report.get(table)).isEmpty()) {
                builder.append("->\n\t\t");
                ((List)report.get(table)).forEach(region -> builder.append(resolver.apply(region)).append(" "));
            } else {
                builder.append(" -> No mismatching regions. This table is good!");
            }
            builder.append("\n\t");
        });
        return builder.toString();
    }

    private String formatReAddedRegionsMessage(List<String> readdedRegionNames, List<Exception> executionErrors) {
        StringBuilder finalText = new StringBuilder();
        finalText.append("Regions re-added into Meta: ").append(readdedRegionNames.size());
        if (!readdedRegionNames.isEmpty()) {
            finalText.append("\n").append("WARNING: \n\t").append(readdedRegionNames.size()).append(" regions were added ").append("to META, but these are not yet on Masters cache. \n").append("You need to restart Masters, then run hbck2 'assigns' command below:\n\t\t").append(this.buildHbck2AssignsCommand(readdedRegionNames));
        }
        if (!executionErrors.isEmpty()) {
            finalText.append("\n").append("ERROR: \n\t").append("There were following errors on at least one table thread:\n");
            executionErrors.forEach(e -> finalText.append(e.getMessage()).append("\n"));
        }
        return finalText.toString();
    }

    private String formatRemovedRegionsMessage(int totalRemoved, List<Exception> executionErrors) {
        StringBuilder finalText = new StringBuilder();
        finalText.append("Regions that had no dir on the FileSystem and got removed from Meta: ").append(totalRemoved);
        if (!executionErrors.isEmpty()) {
            finalText.append("\n").append("ERROR: \n\t").append("There were following errors on at least one table thread:\n");
            executionErrors.forEach(e -> finalText.append(e.getMessage()).append("\n"));
        }
        return finalText.toString();
    }

    private String buildHbck2AssignsCommand(List<String> regions) {
        StringBuilder builder = new StringBuilder();
        builder.append("assigns ");
        regions.forEach(region -> builder.append((String)region).append(" "));
        return builder.toString();
    }

    private static String[] purgeFirst(String[] args) {
        int size = args.length;
        if (size <= 1) {
            return new String[0];
        }
        String[] result = new String[--size];
        System.arraycopy(args, 1, result, 0, size);
        return result;
    }

    private String[] formatSetRegionStateCommand(String[] commands) {
        if (commands.length < 2) {
            HBCK2.showErrorMessage("setRegionState takes region encoded name and state arguments: e.g. 35f30b0ce922c34bf5c284eff33ba8b3 CLOSING");
            return null;
        }
        RegionState.State state = RegionState.State.valueOf((String)commands[1]);
        Integer replicaId = 0;
        String region = commands[0];
        int separatorIndex = commands[0].indexOf(",");
        if (separatorIndex > 0) {
            region = commands[0].substring(0, separatorIndex);
            replicaId = Integer.getInteger(commands[0].substring(separatorIndex + 1));
        }
        if (replicaId > 0) {
            System.out.println("Change state for replica region " + replicaId + " for primary region " + region);
        }
        return new String[]{region, replicaId.toString(), state.name()};
    }

    HBCK2(Configuration conf) {
        super(conf);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int errCode = ToolRunner.run((Tool)new HBCK2(conf), (String[])args);
        if (errCode != 0) {
            System.exit(errCode);
        }
    }

    private List<String> stringArrayToList(String ... nameSpaceOrTable) {
        return nameSpaceOrTable != null ? Arrays.asList(nameSpaceOrTable) : null;
    }

    private List<String> getInputList(String[] args) throws IOException {
        CommandLine commandLine = this.parseCommandWithInputList(args, null);
        if (commandLine == null) {
            return null;
        }
        return this.getFromArgsOrFiles(commandLine.getArgList(), commandLine.hasOption("i"));
    }

    private CommandLine parseCommandWithInputList(String[] args, Options options) {
        if (args == null) {
            return null;
        }
        if (options == null) {
            options = new Options();
        }
        Option inputFile = Option.builder((String)"i").longOpt("inputFiles").build();
        options.addOption(inputFile);
        return this.getCommandLine(args, options);
    }

    private Pair<CommandLine, List<String>> parseCommandWithFixAndInputOptions(String[] args) throws IOException {
        Options options = new Options();
        Option fixOption = Option.builder((String)"f").longOpt("fix").build();
        options.addOption(fixOption);
        CommandLine commandLine = this.parseCommandWithInputList(args, options);
        List<String> params = this.getFromArgsOrFiles(commandLine.getArgList(), commandLine.hasOption("i"));
        return Pair.newPair((Object)commandLine, params);
    }

    private boolean commandHasHelpOption(String[] args) {
        args = HBCK2.purgeFirst(args);
        Options options = new Options();
        Option helpOption = Option.builder((String)"h").longOpt("help").desc("help message for a command").build();
        options.addOption(helpOption);
        CommandLine test = this.getCommandLine(args, options, false);
        return test != null && test.hasOption(helpOption.getOpt());
    }

    private CommandLine getCommandLine(String[] args, Options options, boolean showException) {
        CommandLine commandLine;
        DefaultParser parser = new DefaultParser();
        try {
            commandLine = parser.parse(options, args, false);
        }
        catch (ParseException e) {
            if (showException) {
                HBCK2.showErrorMessage(e.getMessage());
            }
            return null;
        }
        return commandLine;
    }

    private CommandLine getCommandLine(String[] args, Options options) {
        return this.getCommandLine(args, options, true);
    }

    private List<String> getFromArgsOrFiles(List<String> args, boolean getFromFile) throws IOException {
        if (!getFromFile || args == null) {
            return args;
        }
        return this.getFromFiles(args);
    }

    private List<String> getFromFiles(List<String> args) throws IOException {
        ArrayList<String> argList = new ArrayList<String>();
        for (String filePath : args) {
            FileInputStream fileStream = new FileInputStream(filePath);
            Throwable throwable = null;
            try {
                LineIterator it = IOUtils.lineIterator((InputStream)fileStream, (String)"UTF-8");
                while (it.hasNext()) {
                    argList.add(it.nextLine().trim());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)fileStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)fileStream).close();
            }
        }
        return argList;
    }

    static int getBatchSize(Option batchOpt, CommandLine commandLine) throws IllegalArgumentException {
        int batchSize = -1;
        try {
            if (commandLine.hasOption(batchOpt.getOpt()) && (batchSize = Integer.parseInt(commandLine.getOptionValue(batchOpt.getOpt()))) <= 0) {
                throw new IllegalArgumentException("Batch size should be greater than 0!");
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Batch size should be an integer!");
        }
        LOG.info("Batch size set to: " + batchSize);
        return batchSize;
    }
}

