/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.usthe.sureness.subject.SubjectSum;
import com.usthe.sureness.util.SurenessContextHolder;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hertzbeat.alert.dao.AlertDefineBindDao;
import org.apache.hertzbeat.base.dao.LabelDao;
import org.apache.hertzbeat.base.service.LabelService;
import org.apache.hertzbeat.common.entity.grafana.GrafanaDashboard;
import org.apache.hertzbeat.common.entity.job.Configmap;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.manager.Collector;
import org.apache.hertzbeat.common.entity.manager.CollectorMonitorBind;
import org.apache.hertzbeat.common.entity.manager.Monitor;
import org.apache.hertzbeat.common.entity.manager.MonitorBind;
import org.apache.hertzbeat.common.entity.manager.Param;
import org.apache.hertzbeat.common.entity.manager.ParamDefine;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.support.event.MonitorDeletedEvent;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.hertzbeat.common.util.JexlCheckerUtil;
import org.apache.hertzbeat.common.util.SnowFlakeIdGenerator;
import org.apache.hertzbeat.grafana.service.DashboardService;
import org.apache.hertzbeat.manager.component.validator.ParamValidatorManager;
import org.apache.hertzbeat.manager.dao.CollectorDao;
import org.apache.hertzbeat.manager.dao.CollectorMonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorBindDao;
import org.apache.hertzbeat.manager.dao.MonitorDao;
import org.apache.hertzbeat.manager.dao.ParamDao;
import org.apache.hertzbeat.manager.pojo.dto.AppCount;
import org.apache.hertzbeat.manager.pojo.dto.MetricsInfo;
import org.apache.hertzbeat.manager.pojo.dto.MonitorDto;
import org.apache.hertzbeat.manager.scheduler.CollectJobScheduling;
import org.apache.hertzbeat.manager.service.AppService;
import org.apache.hertzbeat.manager.service.MetricsFavoriteService;
import org.apache.hertzbeat.manager.service.MonitorService;
import org.apache.hertzbeat.manager.service.helper.MonitorImExportHelper;
import org.apache.hertzbeat.manager.support.exception.MonitorDatabaseException;
import org.apache.hertzbeat.manager.support.exception.MonitorDetectException;
import org.apache.hertzbeat.warehouse.service.WarehouseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class MonitorServiceImpl
implements MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    public static final String PATTERN_HTTP = "(?i)http://";
    public static final String PATTERN_HTTPS = "(?i)https://";
    private static final Long MONITOR_ID_TMP = 1000000000L;
    private static final byte ALL_MONITOR_STATUS = 9;
    public static final String PARAM_FIELD_PORT = "port";
    @Autowired
    private ParamValidatorManager paramValidatorManager;
    @Autowired
    private MonitorImExportHelper monitorImExportHelper;
    @Autowired
    private AppService appService;
    @Autowired
    private CollectJobScheduling collectJobScheduling;
    @Autowired
    private MonitorDao monitorDao;
    @Autowired
    private ParamDao paramDao;
    @Autowired
    private MonitorBindDao monitorBindDao;
    @Autowired
    private CollectorDao collectorDao;
    @Autowired
    private CollectorMonitorBindDao collectorMonitorBindDao;
    @Autowired
    private AlertDefineBindDao alertDefineBindDao;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private WarehouseService warehouseService;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private LabelDao labelDao;
    @Autowired
    private LabelService labelService;
    @Autowired
    private MetricsFavoriteService metricsFavoriteService;

    @Override
    @Transactional(readOnly=true)
    public void detectMonitor(Monitor monitor, List<Param> params, String collector) throws MonitorDetectException {
        if ("static".equals(monitor.getScrape()) || !StringUtils.hasText((String)monitor.getScrape())) {
            this.detectMonitorDirectly(monitor, params, collector);
        } else {
            this.detectSdMonitor(monitor, params, collector);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addMonitor(Monitor monitor, List<Param> params, String collector, GrafanaDashboard grafanaDashboard) throws RuntimeException {
        String portWithMark;
        List addLabels;
        long monitorId = SnowFlakeIdGenerator.generateId();
        HashMap labels = monitor.getLabels();
        if (labels == null) {
            labels = new HashMap(8);
            monitor.setLabels(labels);
        }
        if (!(addLabels = this.labelService.determineNewLabels(labels.entrySet())).isEmpty()) {
            this.labelDao.saveAll((Iterable)addLabels);
        }
        boolean isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText((String)monitor.getScrape());
        String app = isStatic ? monitor.getApp() : monitor.getScrape();
        Job appDefine = this.appService.getAppDefine(app);
        if (!isStatic) {
            appDefine.setSd(true);
            monitor.setInstance("unknow");
        }
        if ("prometheus".equals(monitor.getApp())) {
            appDefine.setApp("_prometheus_" + monitor.getName());
        }
        appDefine.setMonitorId(monitorId);
        appDefine.setDefaultInterval((long)monitor.getIntervals().intValue());
        appDefine.setCyclic(true);
        appDefine.setTimestamp(System.currentTimeMillis());
        Object instance = monitor.getInstance();
        Param portParam = params.stream().filter(param -> PARAM_FIELD_PORT.equals(param.getField())).findFirst().orElse(null);
        String string = portWithMark = Objects.isNull(portParam) || !StringUtils.hasText((String)portParam.getParamValue()) ? "" : ":" + portParam.getParamValue();
        if (!IpDomainUtil.isHasPortWithMark((String)instance)) {
            instance = (String)instance + portWithMark;
        }
        monitor.setInstance((String)instance);
        Map<String, Object> metadata = Map.of("instancename", monitor.getName(), "instance", instance);
        appDefine.setMetadata(metadata);
        appDefine.setLabels(monitor.getLabels());
        appDefine.setAnnotations(monitor.getAnnotations());
        List configmaps = params.stream().map(param -> {
            param.setMonitorId(Long.valueOf(monitorId));
            return new Configmap(param.getField(), (Object)param.getParamValue(), param.getType());
        }).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        long jobId = collector == null ? this.collectJobScheduling.addAsyncCollectJob(appDefine, null) : this.collectJobScheduling.addAsyncCollectJob(appDefine, collector);
        try {
            this.detectMonitor(monitor, params, collector);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (collector != null) {
                CollectorMonitorBind collectorMonitorBind = CollectorMonitorBind.builder().collector(collector).monitorId(Long.valueOf(monitorId)).build();
                this.collectorMonitorBindDao.save(collectorMonitorBind);
            }
            monitor.setId(Long.valueOf(monitorId));
            monitor.setJobId(Long.valueOf(jobId));
            if (monitor.getApp().equals("prometheus") && grafanaDashboard != null && grafanaDashboard.isEnabled()) {
                this.dashboardService.createOrUpdateDashboard(grafanaDashboard.getTemplate(), Long.valueOf(monitorId));
            }
            this.monitorDao.save(monitor);
            this.paramDao.saveAll(params);
        }
        catch (Exception e) {
            log.error("Error while adding monitor: {}", (Object)e.getMessage(), (Object)e);
            this.collectJobScheduling.cancelAsyncCollectJob(jobId);
            throw new MonitorDatabaseException(e.getMessage());
        }
    }

    @Override
    public void export(List<Long> ids, String type, HttpServletResponse res) throws Exception {
        this.monitorImExportHelper.export(ids, type, res);
    }

    @Override
    public void exportAll(String type, HttpServletResponse res) throws Exception {
        List<Long> allMonitorIds = this.monitorDao.findAll().stream().map(Monitor::getId).collect(Collectors.toList());
        this.export(allMonitorIds, type, res);
    }

    @Override
    public void importConfig(MultipartFile file) throws Exception {
        this.monitorImExportHelper.importConfig(file);
    }

    @Override
    @Transactional(readOnly=true)
    public void validate(MonitorDto monitorDto, Boolean isModify) throws IllegalArgumentException {
        Monitor monitor;
        monitor.setInstance(StringUtils.hasText((String)(monitor = monitorDto.getMonitor()).getInstance()) ? monitor.getInstance().trim() : null);
        monitor.setName(monitor.getName().trim());
        Map<String, Param> paramMap = monitorDto.getParams().stream().peek(param -> {
            param.setMonitorId(monitor.getId());
            String value = param.getParamValue() == null ? null : param.getParamValue().trim();
            param.setParamValue(value);
        }).collect(Collectors.toMap(Param::getField, param -> param));
        if (isModify != null) {
            Optional<Job> defineOptional = this.appService.getAppDefineOption(monitor.getName());
            if (defineOptional.isPresent()) {
                throw new IllegalArgumentException("Monitoring name cannot be the existed monitoring type name!");
            }
            Optional<Monitor> monitorOptional = this.monitorDao.findMonitorByNameEquals(monitor.getName());
            if (monitorOptional.isPresent()) {
                Monitor existMonitor = monitorOptional.get();
                if (isModify.booleanValue()) {
                    if (!existMonitor.getId().equals(monitor.getId())) {
                        throw new IllegalArgumentException("Monitoring name already exists!");
                    }
                } else {
                    throw new IllegalArgumentException("Monitoring name already exists!");
                }
            }
        }
        if (StringUtils.hasText((String)monitorDto.getCollector())) {
            Optional<Collector> optionalCollector = this.collectorDao.findCollectorByName(monitorDto.getCollector());
            if (optionalCollector.isEmpty()) {
                throw new IllegalArgumentException("The pinned collector does not exist.");
            }
        } else {
            monitorDto.setCollector(null);
        }
        List<ParamDefine> paramDefines = this.appService.getAppParamDefines(monitorDto.getMonitor().getApp());
        if (!CollectionUtils.isEmpty(paramDefines)) {
            boolean isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText((String)monitor.getScrape());
            for (ParamDefine paramDefine : paramDefines) {
                String field = paramDefine.getField();
                Param param2 = paramMap.get(field);
                if (!isStatic && "host".equals(field)) continue;
                if (paramDefine.isRequired() && (param2 == null || param2.getParamValue() == null)) {
                    throw new IllegalArgumentException("Params field " + field + " is required.");
                }
                if (param2 == null || !StringUtils.hasText((String)param2.getParamValue())) continue;
                this.paramValidatorManager.validate(paramDefine, param2);
            }
        }
        this.checkJobFields(monitorDto.getMonitor().getApp());
    }

    private void checkJobFields(String app) {
        if (null == app || app.trim().isEmpty()) {
            return;
        }
        Job job = this.appService.getAppDefine(app);
        if (null != job && !CollectionUtils.isEmpty((Collection)job.getMetrics())) {
            for (Metrics metrics : job.getMetrics()) {
                if (null == metrics.getFields() || metrics.getFields().isEmpty()) continue;
                for (Metrics.Field field : metrics.getFields()) {
                    if (JexlCheckerUtil.verifyKeywords((String)field.getField())) {
                        throw new IllegalArgumentException(job.getApp() + " " + metrics.getName() + " " + field.getField() + " prohibited keywords, please modify the template information.");
                    }
                    if (JexlCheckerUtil.verifyStartCharacter((String)field.getField())) {
                        throw new IllegalArgumentException(job.getApp() + " " + metrics.getName() + " " + field.getField() + " illegal start character, please modify the template information.");
                    }
                    if (!JexlCheckerUtil.verifySpaces((String)field.getField())) continue;
                    throw new IllegalArgumentException(job.getApp() + " " + metrics.getName() + " " + field.getField() + " no spaces allowed, please modify the template information.");
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyMonitor(Monitor monitor, List<Param> params, String collector, GrafanaDashboard grafanaDashboard) throws RuntimeException {
        boolean isStatic;
        String portWithMark;
        List addLabels;
        long monitorId = monitor.getId();
        Optional queryOption = this.monitorDao.findById(monitorId);
        if (queryOption.isEmpty()) {
            throw new IllegalArgumentException("The Monitor " + monitorId + " not exists");
        }
        Monitor preMonitor = (Monitor)queryOption.get();
        if (!preMonitor.getApp().equals(monitor.getApp())) {
            throw new IllegalArgumentException("Can not modify monitor's app type");
        }
        HashMap labels = monitor.getLabels();
        if (labels == null) {
            labels = new HashMap(8);
            monitor.setLabels(labels);
        }
        if (!(addLabels = this.labelService.determineNewLabels(labels.entrySet())).isEmpty()) {
            this.labelDao.saveAll((Iterable)addLabels);
        }
        Object instance = monitor.getInstance();
        Param portParam = params.stream().filter(param -> PARAM_FIELD_PORT.equals(param.getField())).findFirst().orElse(null);
        String string = portWithMark = Objects.isNull(portParam) || !StringUtils.hasText((String)portParam.getParamValue()) ? "" : ":" + portParam.getParamValue();
        if (Objects.nonNull(instance)) {
            instance = (String)instance + portWithMark;
        }
        monitor.setInstance((String)instance);
        boolean bl = isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText((String)monitor.getScrape());
        if (preMonitor.getStatus() != 0) {
            String app = isStatic ? monitor.getApp() : monitor.getScrape();
            Job appDefine = this.appService.getAppDefine(app);
            if (!isStatic) {
                appDefine.setSd(true);
            }
            if ("prometheus".equals(monitor.getApp())) {
                appDefine.setApp("_prometheus_" + monitor.getName());
            }
            appDefine.setId(preMonitor.getJobId().longValue());
            appDefine.setMonitorId(monitorId);
            appDefine.setDefaultInterval((long)monitor.getIntervals().intValue());
            appDefine.setCyclic(true);
            appDefine.setTimestamp(System.currentTimeMillis());
            appDefine.setScheduleType(monitor.getScheduleType());
            appDefine.setCronExpression(monitor.getCronExpression());
            Map<String, String> metadata = Map.of("instancename", monitor.getName(), "instance", monitor.getInstance());
            appDefine.setMetadata(metadata);
            appDefine.setLabels(monitor.getLabels());
            appDefine.setAnnotations(monitor.getAnnotations());
            List configmaps = params.stream().map(param -> new Configmap(param.getField(), (Object)param.getParamValue(), param.getType())).collect(Collectors.toList());
            appDefine.setConfigmap(configmaps);
            long newJobId = collector == null ? this.collectJobScheduling.updateAsyncCollectJob(appDefine) : this.collectJobScheduling.updateAsyncCollectJob(appDefine, collector);
            monitor.setJobId(Long.valueOf(newJobId));
            try {
                this.detectMonitor(monitor, params, collector);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.collectorMonitorBindDao.deleteCollectorMonitorBindsByMonitorId(monitorId);
            if (collector != null) {
                CollectorMonitorBind collectorMonitorBind = CollectorMonitorBind.builder().collector(collector).monitorId(Long.valueOf(monitorId)).build();
                this.collectorMonitorBindDao.save(collectorMonitorBind);
            }
            monitor.setGmtUpdate(LocalDateTime.now());
            if (monitor.getApp().equals("prometheus") && grafanaDashboard != null) {
                if (grafanaDashboard.isEnabled()) {
                    this.dashboardService.createOrUpdateDashboard(grafanaDashboard.getTemplate(), Long.valueOf(monitorId));
                } else {
                    this.dashboardService.closeGrafanaDashboard(Long.valueOf(monitorId));
                }
            }
            this.monitorDao.save(monitor);
            this.paramDao.saveAll(params);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.collectJobScheduling.cancelAsyncCollectJob(monitor.getJobId());
            throw new MonitorDatabaseException(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMonitor(long id) throws RuntimeException {
        this.deleteMonitors(Sets.newHashSet((Object[])new Long[]{id}));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteMonitors(Set<Long> ids) throws RuntimeException {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Set subMonitorIds = this.monitorBindDao.findMonitorBindsByBizIdIn(ids).stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
        HashSet<Long> allMonitorIds = new HashSet<Long>(ids);
        allMonitorIds.addAll(subMonitorIds);
        List<Monitor> monitors = this.monitorDao.findMonitorsByIdIn(allMonitorIds);
        if (!monitors.isEmpty()) {
            this.monitorDao.deleteAll(monitors);
            this.paramDao.deleteParamsByMonitorIdIn(ids);
            Set<Long> monitorIds = monitors.stream().map(Monitor::getId).collect(Collectors.toSet());
            this.alertDefineBindDao.deleteAlertDefineMonitorBindsByMonitorIdIn(monitorIds);
            this.monitorBindDao.deleteMonitorBindByBizIdIn(monitorIds);
            this.metricsFavoriteService.deleteFavoritesByMonitorIdIn(monitorIds);
            for (Monitor monitor : monitors) {
                this.monitorBindDao.deleteByMonitorId(monitor.getId());
                this.collectorMonitorBindDao.deleteCollectorMonitorBindsByMonitorId(monitor.getId());
                this.collectJobScheduling.cancelAsyncCollectJob(monitor.getJobId());
                this.applicationContext.publishEvent((ApplicationEvent)new MonitorDeletedEvent((Object)this.applicationContext, monitor.getId()));
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public MonitorDto getMonitorDto(long id) throws RuntimeException {
        Optional monitorOptional = this.monitorDao.findById(id);
        if (monitorOptional.isPresent()) {
            List<MetricsInfo> metricsInfos;
            String currentUserId = null;
            try {
                SubjectSum subjectSum = SurenessContextHolder.getBindSubject();
                currentUserId = String.valueOf(subjectSum.getPrincipal());
            }
            catch (Exception e) {
                log.debug("No user context found, favorites will be disabled");
            }
            Set<String> favoritedMetrics = this.metricsFavoriteService.getUserFavoritedMetrics(currentUserId, id);
            Monitor monitor = (Monitor)monitorOptional.get();
            MonitorDto monitorDto = new MonitorDto();
            List<Param> params = this.paramDao.findParamsByMonitorId(id);
            monitorDto.setParams(params);
            if ("prometheus".equalsIgnoreCase(monitor.getApp()) || monitor.getType() == 1) {
                List metricsDataList = this.warehouseService.queryMonitorMetricsData(Long.valueOf(id));
                metricsInfos = metricsDataList.stream().map(t -> MetricsInfo.builder().name(t.getMetrics()).favorited(favoritedMetrics.contains(t.getMetrics())).build()).collect(Collectors.toList());
                monitorDto.setGrafanaDashboard(this.dashboardService.getDashboardByMonitorId(Long.valueOf(id)));
            } else {
                boolean isStatic = "static".equals(monitor.getScrape()) || !StringUtils.hasText((String)monitor.getScrape());
                String type = isStatic ? monitor.getApp() : monitor.getScrape();
                Job job = this.appService.getAppDefine(type);
                metricsInfos = job.getMetrics().stream().filter(Metrics::isVisible).map(t -> MetricsInfo.builder().name(t.getName()).favorited(favoritedMetrics.contains(t.getName())).build()).collect(Collectors.toList());
            }
            monitorDto.setMetrics(metricsInfos);
            monitorDto.setMonitor(monitor);
            Optional<CollectorMonitorBind> bindOptional = this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(monitor.getId());
            bindOptional.ifPresent(bind -> monitorDto.setCollector(bind.getCollector()));
            return monitorDto;
        }
        return null;
    }

    @Override
    public Page<Monitor> getMonitors(List<Long> monitorIds, String app, String search, Byte status, String sort, String order, int pageIndex, int pageSize, String labels) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Object> andList = new ArrayList<Object>();
            if (!CollectionUtils.isEmpty((Collection)monitorIds)) {
                CriteriaBuilder.In inPredicate = criteriaBuilder.in((Expression)root.get("id"));
                Iterator iterator = monitorIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    inPredicate.value((Object)id);
                }
                andList.add(inPredicate);
            }
            if (StringUtils.hasText((String)app)) {
                Predicate predicateApp = criteriaBuilder.equal((Expression)root.get("app"), (Object)app);
                andList.add(predicateApp);
            }
            if (status != null && status >= 0 && status < 9) {
                Predicate predicateStatus = criteriaBuilder.equal((Expression)root.get("status"), (Object)status);
                andList.add(predicateStatus);
            }
            Predicate[] andPredicates = new Predicate[andList.size()];
            Predicate andPredicate = criteriaBuilder.and(andList.toArray(andPredicates));
            ArrayList<Predicate> orList = new ArrayList<Predicate>();
            if (StringUtils.hasText((String)search)) {
                Predicate predicateHost = criteriaBuilder.like((Expression)root.get("instance"), "%" + search + "%");
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + search.toLowerCase() + "%");
                Long id = Longs.tryParse((String)search);
                if (id != null) {
                    orList.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)id));
                }
                orList.add(predicateHost);
                orList.add(predicateName);
            }
            if (StringUtils.hasText((String)labels)) {
                Predicate labelAres;
                for (Predicate label : labelAres = labels.split(",")) {
                    String labelValue;
                    String[] labelArr = label.split(":");
                    String labelName = labelArr[0];
                    String string = labelValue = labelArr.length == 2 ? labelArr[1] : null;
                    if (labelValue == null) {
                        orList.add(criteriaBuilder.like((Expression)root.get("labels"), "%" + labelName + "%"));
                        continue;
                    }
                    String pattern = String.format("%%\"%s\":\"%s\"%%", labelName, labelValue);
                    orList.add(criteriaBuilder.like((Expression)root.get("labels"), pattern));
                }
            }
            Predicate[] orPredicates = new Predicate[orList.size()];
            Predicate orPredicate = criteriaBuilder.or(orList.toArray(orPredicates));
            if (andPredicates.length == 0 && orPredicates.length == 0) {
                return query.where(new Predicate[0]).getRestriction();
            }
            if (andPredicates.length == 0) {
                return orPredicate;
            }
            if (orPredicates.length == 0) {
                return andPredicate;
            }
            return query.where(new Predicate[]{andPredicate, orPredicate}).getRestriction();
        };
        Sort sortExp = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.fromString((String)order), sort)});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sortExp);
        return this.monitorDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public void cancelManageMonitors(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        Set subMonitorIds = this.monitorBindDao.findMonitorBindsByBizIdIn(ids).stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
        ids.addAll(subMonitorIds);
        List managedMonitors = this.monitorDao.findMonitorsByIdIn(ids).stream().filter(monitor -> monitor.getStatus() != 0).peek(monitor -> monitor.setStatus((byte)0)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(managedMonitors)) {
            for (Monitor monitor2 : managedMonitors) {
                this.collectJobScheduling.cancelAsyncCollectJob(monitor2.getJobId());
            }
            this.monitorDao.saveAll(managedMonitors);
        }
    }

    @Override
    public void enableManageMonitors(Set<Long> ids) {
        Set subMonitorIds = this.monitorBindDao.findMonitorBindsByBizIdIn(ids).stream().map(MonitorBind::getMonitorId).collect(Collectors.toSet());
        ids.addAll(subMonitorIds);
        List unManagedMonitors = this.monitorDao.findMonitorsByIdIn(ids).stream().filter(monitor -> monitor.getStatus() == 0).peek(monitor -> monitor.setStatus((byte)1)).collect(Collectors.toList());
        if (unManagedMonitors.isEmpty()) {
            return;
        }
        for (Monitor monitor2 : unManagedMonitors) {
            List<Param> params = this.paramDao.findParamsByMonitorId(monitor2.getId());
            boolean isStatic = "static".equals(monitor2.getScrape()) || !StringUtils.hasText((String)monitor2.getScrape());
            String app = isStatic ? monitor2.getApp() : monitor2.getScrape();
            Job appDefine = this.appService.getAppDefine(app);
            if (!isStatic) {
                appDefine.setSd(true);
            }
            if ("prometheus".equals(monitor2.getApp())) {
                appDefine.setApp("_prometheus_" + monitor2.getName());
            }
            appDefine.setMonitorId(monitor2.getId().longValue());
            appDefine.setDefaultInterval((long)monitor2.getIntervals().intValue());
            appDefine.setCyclic(true);
            appDefine.setTimestamp(System.currentTimeMillis());
            appDefine.setScheduleType(monitor2.getScheduleType());
            appDefine.setCronExpression(monitor2.getCronExpression());
            Map<String, String> metadata = Map.of("instancename", monitor2.getName(), "instance", monitor2.getInstance());
            appDefine.setMetadata(metadata);
            appDefine.setLabels(monitor2.getLabels());
            appDefine.setAnnotations(monitor2.getAnnotations());
            List configmaps = params.stream().map(param -> new Configmap(param.getField(), (Object)param.getParamValue(), param.getType())).collect(Collectors.toList());
            List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText((String)item.getDefaultValue())).toList();
            paramDefaultValue.forEach(defaultVar -> {
                if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                    Configmap configmap = new Configmap(defaultVar.getField(), (Object)defaultVar.getDefaultValue(), 1);
                    configmaps.add(configmap);
                }
            });
            appDefine.setConfigmap(configmaps);
            Optional<CollectorMonitorBind> bindOptional = this.collectorMonitorBindDao.findCollectorMonitorBindByMonitorId(monitor2.getId());
            String collector = bindOptional.map(CollectorMonitorBind::getCollector).orElse(null);
            long newJobId = this.collectJobScheduling.addAsyncCollectJob(appDefine, collector);
            monitor2.setJobId(Long.valueOf(newJobId));
            this.applicationContext.publishEvent((ApplicationEvent)new MonitorDeletedEvent((Object)this.applicationContext, monitor2.getId()));
            try {
                this.detectMonitor(monitor2, params, collector);
            }
            catch (Exception exception) {}
        }
        this.monitorDao.saveAll(unManagedMonitors);
    }

    @Override
    public List<AppCount> getAllAppMonitorsCount() {
        List<AppCount> appCounts = this.monitorDao.findAppsStatusCount();
        if (CollectionUtils.isEmpty(appCounts)) {
            return null;
        }
        HashMap<String, AppCount> appCountMap = new HashMap<String, AppCount>(appCounts.size());
        for (AppCount item2 : appCounts) {
            AppCount appCount = appCountMap.getOrDefault(item2.getApp(), new AppCount());
            appCount.setApp(item2.getApp());
            switch (item2.getStatus()) {
                case 1: {
                    appCount.setAvailableSize(appCount.getAvailableSize() + item2.getSize());
                    break;
                }
                case 2: {
                    appCount.setUnAvailableSize(appCount.getUnAvailableSize() + item2.getSize());
                    break;
                }
                case 0: {
                    appCount.setUnManageSize(appCount.getUnManageSize() + item2.getSize());
                    break;
                }
            }
            appCountMap.put(item2.getApp(), appCount);
        }
        return appCountMap.values().stream().map(item -> {
            item.setSize(item.getAvailableSize() + item.getUnManageSize() + item.getUnAvailableSize());
            try {
                Job job = this.appService.getAppDefine(item.getApp());
                item.setCategory(job.getCategory());
            }
            catch (Exception ignored) {
                return null;
            }
            return item;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void updateAppCollectJob(Job job) {
        List<Monitor> monitors = this.monitorDao.findMonitorsByAppEquals(job.getApp()).stream().filter(monitor -> monitor.getStatus() != 0).toList();
        if (monitors.isEmpty()) {
            return;
        }
        List<CollectorMonitorBind> monitorBinds = this.collectorMonitorBindDao.findCollectorMonitorBindsByMonitorIdIn(monitors.stream().map(Monitor::getId).collect(Collectors.toSet()));
        Map<Long, String> monitorIdCollectorMap = monitorBinds.stream().collect(Collectors.toMap(CollectorMonitorBind::getMonitorId, CollectorMonitorBind::getCollector));
        for (Monitor monitor2 : monitors) {
            try {
                Job appDefine = job.clone();
                if (monitor2 == null || appDefine == null || monitor2.getId() == null || monitor2.getJobId() == null) {
                    log.error("update monitor job error when template modify, define | id | jobId is null. continue");
                    continue;
                }
                if ("prometheus".equals(monitor2.getApp())) {
                    appDefine.setApp("_prometheus_" + monitor2.getName());
                }
                appDefine.setId(monitor2.getJobId().longValue());
                appDefine.setMonitorId(monitor2.getId().longValue());
                appDefine.setDefaultInterval((long)monitor2.getIntervals().intValue());
                appDefine.setCyclic(true);
                appDefine.setTimestamp(System.currentTimeMillis());
                Map<String, String> metadata = Map.of("instancename", monitor2.getName(), "instance", monitor2.getInstance());
                appDefine.setMetadata(metadata);
                appDefine.setLabels(monitor2.getLabels());
                appDefine.setAnnotations(monitor2.getAnnotations());
                List<Param> params = this.paramDao.findParamsByMonitorId(monitor2.getId());
                List configmaps = params.stream().map(param -> new Configmap(param.getField(), (Object)param.getParamValue(), param.getType())).collect(Collectors.toList());
                List<ParamDefine> paramDefaultValue = appDefine.getParams().stream().filter(item -> StringUtils.hasText((String)item.getDefaultValue())).toList();
                paramDefaultValue.forEach(defaultVar -> {
                    if (configmaps.stream().noneMatch(item -> item.getKey().equals(defaultVar.getField()))) {
                        Configmap configmap = new Configmap(defaultVar.getField(), (Object)defaultVar.getDefaultValue(), 1);
                        configmaps.add(configmap);
                    }
                });
                appDefine.setConfigmap(configmaps);
                String collector = monitorIdCollectorMap.get(monitor2.getId());
                long newJobId = this.collectJobScheduling.updateAsyncCollectJob(appDefine, collector);
                monitor2.setJobId(Long.valueOf(newJobId));
                this.monitorDao.save(monitor2);
            }
            catch (Exception e) {
                log.error("update monitor job error when template modify: {}.continue", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public Monitor getMonitor(Long monitorId) {
        return this.monitorDao.findById(monitorId).orElse(null);
    }

    @Override
    public void updateMonitorStatus(Long monitorId, byte status) {
        this.monitorDao.updateMonitorStatus(monitorId, status);
    }

    @Override
    public List<Monitor> getAppMonitors(String app) {
        return this.monitorDao.findMonitorsByAppEquals(app);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyMonitor(Long id) {
        Optional monitorOptional = this.monitorDao.findById(id);
        if (monitorOptional.isEmpty()) {
            throw new IllegalArgumentException("Monitor not found: " + id);
        }
        Monitor sourceMonitor = (Monitor)monitorOptional.get();
        List<Param> sourceParams = this.paramDao.findParamsByMonitorId(id);
        Monitor newMonitor = new Monitor();
        BeanUtils.copyProperties((Object)sourceMonitor, (Object)newMonitor, (String[])new String[]{"id", "jobId", "status"});
        newMonitor.setName(sourceMonitor.getName() + "_copy");
        newMonitor.setStatus((byte)1);
        newMonitor.setGmtCreate(LocalDateTime.now());
        newMonitor.setGmtUpdate(LocalDateTime.now());
        ArrayList<Param> newParams = new ArrayList<Param>();
        if (!sourceParams.isEmpty()) {
            for (Param sourceParam : sourceParams) {
                Param newParam = new Param();
                BeanUtils.copyProperties((Object)sourceParam, (Object)newParam, (String[])new String[]{"id"});
                newParam.setMonitorId(newMonitor.getId());
                newParams.add(newParam);
            }
        }
        this.addMonitor(newMonitor, newParams, null, null);
    }

    private void detectSdMonitor(Monitor monitor, List<Param> params, String collector) {
        Long monitorId = monitor.getId();
        if (monitorId == null || monitorId == 0L) {
            monitorId = MONITOR_ID_TMP;
        }
        if (monitor.getScrape() == null || params == null || params.isEmpty()) {
            throw new IllegalArgumentException("scrape params is null or empty!");
        }
        Job appDefine = this.appService.getAppDefine(monitor.getScrape());
        appDefine.setMonitorId(monitorId.longValue());
        appDefine.setCyclic(false);
        appDefine.setTimestamp(System.currentTimeMillis());
        Map<String, String> metadata = Map.of("instancename", monitor.getName());
        appDefine.setMetadata(metadata);
        appDefine.setLabels(monitor.getLabels());
        appDefine.setAnnotations(monitor.getAnnotations());
        List configmaps = params.stream().map(param -> new Configmap(param.getField(), (Object)param.getParamValue(), param.getType())).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        appDefine.setSd(true);
        List<CollectRep.MetricsData> collectRep = collector != null ? this.collectJobScheduling.collectSyncJobData(appDefine, collector) : this.collectJobScheduling.collectSyncJobData(appDefine);
        monitor.setStatus((byte)1);
        if (collectRep == null || collectRep.isEmpty()) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException("Collect Timeout No Response");
        }
        if (collectRep.get(0).getCode() != CollectRep.Code.SUCCESS) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException(collectRep.get(0).getMsg());
        }
        collectRep.forEach(CollectRep.MetricsData::close);
    }

    private void detectMonitorDirectly(Monitor monitor, List<Param> params, String collector) {
        Long monitorId = monitor.getId();
        if (monitorId == null || monitorId == 0L) {
            monitorId = MONITOR_ID_TMP;
        }
        Job appDefine = this.appService.getAppDefine(monitor.getApp());
        if ("prometheus".equals(monitor.getApp())) {
            appDefine.setApp("_prometheus_" + monitor.getName());
        }
        appDefine.setMonitorId(monitorId.longValue());
        appDefine.setCyclic(false);
        appDefine.setTimestamp(System.currentTimeMillis());
        Map<String, String> metadata = Map.of("instancename", monitor.getName(), "instance", monitor.getInstance());
        appDefine.setMetadata(metadata);
        appDefine.setLabels(monitor.getLabels());
        appDefine.setAnnotations(monitor.getAnnotations());
        List configmaps = params.stream().map(param -> new Configmap(param.getField(), (Object)param.getParamValue(), param.getType())).collect(Collectors.toList());
        appDefine.setConfigmap(configmaps);
        List availableMetrics = appDefine.getMetrics().stream().filter(item -> item.getPriority() == 0).collect(Collectors.toList());
        appDefine.setMetrics(availableMetrics);
        List<CollectRep.MetricsData> collectRep = collector != null ? this.collectJobScheduling.collectSyncJobData(appDefine, collector) : this.collectJobScheduling.collectSyncJobData(appDefine);
        monitor.setStatus((byte)1);
        if (collectRep == null || collectRep.isEmpty()) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException("Collect Timeout No Response");
        }
        if (collectRep.get(0).getCode() != CollectRep.Code.SUCCESS) {
            monitor.setStatus((byte)2);
            throw new MonitorDetectException(collectRep.get(0).getMsg());
        }
        collectRep.forEach(CollectRep.MetricsData::close);
    }
}

