/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.impl;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.manager.StatusPageComponent;
import org.apache.hertzbeat.common.entity.manager.StatusPageHistory;
import org.apache.hertzbeat.common.entity.manager.StatusPageIncident;
import org.apache.hertzbeat.common.entity.manager.StatusPageOrg;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.manager.component.status.CalculateStatus;
import org.apache.hertzbeat.manager.dao.StatusPageComponentDao;
import org.apache.hertzbeat.manager.dao.StatusPageHistoryDao;
import org.apache.hertzbeat.manager.dao.StatusPageIncidentComponentBindDao;
import org.apache.hertzbeat.manager.dao.StatusPageIncidentDao;
import org.apache.hertzbeat.manager.dao.StatusPageOrgDao;
import org.apache.hertzbeat.manager.pojo.dto.ComponentStatus;
import org.apache.hertzbeat.manager.service.StatusPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class StatusPageServiceImpl
implements StatusPageService {
    private static final int HISTORY_SPAN_DAYS = 29;
    @Autowired
    private StatusPageOrgDao statusPageOrgDao;
    @Autowired
    private StatusPageComponentDao statusPageComponentDao;
    @Autowired
    private StatusPageHistoryDao statusPageHistoryDao;
    @Autowired
    private StatusPageIncidentDao statusPageIncidentDao;
    @Autowired
    private CalculateStatus calculateStatus;
    private final StatusPageIncidentComponentBindDao statusPageIncidentComponentBindDao;

    @Override
    public StatusPageOrg queryStatusPageOrg() {
        return this.statusPageOrgDao.findAll().stream().findFirst().orElse(null);
    }

    @Override
    public StatusPageOrg saveStatusPageOrg(StatusPageOrg statusPageOrg) {
        return (StatusPageOrg)this.statusPageOrgDao.save(statusPageOrg);
    }

    @Override
    public List<StatusPageComponent> queryStatusPageComponents() {
        return this.statusPageComponentDao.findAll();
    }

    @Override
    public void newStatusPageComponent(StatusPageComponent statusPageComponent) {
        if (statusPageComponent.getMethod() == 1) {
            statusPageComponent.setState(statusPageComponent.getConfigState());
        }
        this.statusPageComponentDao.save(statusPageComponent);
    }

    @Override
    public void updateStatusPageComponent(StatusPageComponent statusPageComponent) {
        if (statusPageComponent.getMethod() == 1) {
            statusPageComponent.setState(statusPageComponent.getConfigState());
        }
        this.statusPageComponentDao.save(statusPageComponent);
    }

    @Override
    public void deleteStatusPageComponent(long id) {
        long count = this.statusPageIncidentComponentBindDao.countByComponentId(id);
        if (count != 0L) {
            throw new CommonException("The component is associated with an event and cannot be deleted. Please delete the event and try again!");
        }
        this.statusPageComponentDao.deleteById(id);
    }

    @Override
    public StatusPageComponent queryStatusPageComponent(long id) {
        return this.statusPageComponentDao.findById(id).orElse(null);
    }

    @Override
    public List<ComponentStatus> queryComponentsStatus() {
        List components = this.statusPageComponentDao.findAll();
        LinkedList<ComponentStatus> componentStatusList = new LinkedList<ComponentStatus>();
        for (StatusPageComponent component : components) {
            ComponentStatus componentStatus = new ComponentStatus();
            componentStatus.setInfo(component);
            LinkedList<StatusPageHistory> histories = new LinkedList<StatusPageHistory>();
            ZoneId zoneId = ZoneId.systemDefault();
            Instant now = Instant.now();
            long nowTimestamp = now.toEpochMilli();
            long todayStartTimestamp = now.atZone(zoneId).toLocalDate().atStartOfDay(zoneId).toInstant().toEpochMilli();
            List<StatusPageHistory> todayStatusPageHistoryList = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), todayStartTimestamp, nowTimestamp);
            StatusPageHistory todayStatus = this.combineOneDayStatusPageHistory(todayStatusPageHistoryList, component, nowTimestamp);
            histories.add(todayStatus);
            long preTimestamp = now.atZone(zoneId).toLocalDate().minusDays(29L).atStartOfDay(zoneId).toInstant().toEpochMilli();
            List<StatusPageHistory> history = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), preTimestamp, todayStartTimestamp);
            LinkedList<StatusPageHistory> historyList = new LinkedList<StatusPageHistory>(history);
            historyList.sort((o1, o2) -> Long.compare(o1.getTimestamp(), o2.getTimestamp()));
            ZonedDateTime end = Instant.ofEpochMilli(todayStartTimestamp).atZone(zoneId).minusSeconds(1L);
            for (int i = 0; i < 29; ++i) {
                long endTimestamp = end.toInstant().toEpochMilli();
                long startTimestamp = end.toLocalDate().atStartOfDay(zoneId).toInstant().toEpochMilli();
                List<StatusPageHistory> thisDayHistory = historyList.stream().filter(h -> h.getTimestamp() >= startTimestamp && h.getTimestamp() <= endTimestamp).collect(Collectors.toList());
                if (thisDayHistory.isEmpty()) {
                    histories.add(StatusPageHistory.builder().timestamp(Long.valueOf(endTimestamp)).componentId(component.getId()).state((byte)2).build());
                } else if (thisDayHistory.size() == 1) {
                    histories.add((StatusPageHistory)thisDayHistory.get(0));
                } else {
                    StatusPageHistory merged = this.combineOneDayStatusPageHistory(thisDayHistory, component, endTimestamp);
                    histories.add(merged);
                    this.statusPageHistoryDao.deleteAll(thisDayHistory);
                    this.statusPageHistoryDao.save(merged);
                }
                end = end.minusDays(1L);
            }
            componentStatus.setHistory(histories);
            componentStatusList.add(componentStatus);
        }
        return componentStatusList;
    }

    private StatusPageHistory combineOneDayStatusPageHistory(List<StatusPageHistory> statusPageHistories, StatusPageComponent component, long nowTimestamp) {
        if (statusPageHistories.isEmpty()) {
            return StatusPageHistory.builder().timestamp(Long.valueOf(nowTimestamp)).normal(Integer.valueOf(0)).abnormal(Integer.valueOf(0)).unknowing(Integer.valueOf(0)).componentId(component.getId()).state(component.getState()).build();
        }
        if (statusPageHistories.size() == 1) {
            return statusPageHistories.get(0);
        }
        StatusPageHistory oldOne = statusPageHistories.get(0);
        StatusPageHistory todayStatus = StatusPageHistory.builder().timestamp(Long.valueOf(nowTimestamp)).normal(Integer.valueOf(0)).abnormal(Integer.valueOf(0)).unknowing(Integer.valueOf(0)).gmtCreate(oldOne.getGmtCreate()).gmtUpdate(oldOne.getGmtUpdate()).componentId(component.getId()).state(component.getState()).build();
        for (StatusPageHistory statusPageHistory : statusPageHistories) {
            if (statusPageHistory.getState() == 1) {
                todayStatus.setAbnormal(Integer.valueOf(todayStatus.getAbnormal() + this.calculateStatus.getCalculateStatusIntervals()));
                continue;
            }
            if (statusPageHistory.getState() == 2) {
                todayStatus.setUnknowing(Integer.valueOf(todayStatus.getUnknowing() + this.calculateStatus.getCalculateStatusIntervals()));
                continue;
            }
            todayStatus.setNormal(Integer.valueOf(todayStatus.getNormal() + this.calculateStatus.getCalculateStatusIntervals()));
        }
        double total = todayStatus.getNormal() + todayStatus.getAbnormal() + todayStatus.getUnknowing();
        double uptime = 0.0;
        if (total > 0.0) {
            uptime = (double)todayStatus.getNormal().intValue() / total;
        }
        todayStatus.setUptime(Double.valueOf(uptime));
        if (todayStatus.getAbnormal() > 0) {
            todayStatus.setState((byte)1);
        } else if (todayStatus.getNormal() > 0) {
            todayStatus.setState((byte)0);
        } else {
            todayStatus.setState((byte)2);
        }
        return todayStatus;
    }

    @Override
    public ComponentStatus queryComponentStatus(long id) {
        StatusPageComponent component = (StatusPageComponent)this.statusPageComponentDao.findById(id).orElseThrow(() -> new IllegalArgumentException("component not found"));
        ComponentStatus componentStatus = new ComponentStatus();
        componentStatus.setInfo(component);
        LinkedList<StatusPageHistory> histories = new LinkedList<StatusPageHistory>();
        ZoneId zoneId = ZoneId.systemDefault();
        Instant now = Instant.now();
        long nowTimestamp = now.toEpochMilli();
        long todayStartTimestamp = now.atZone(zoneId).toLocalDate().atStartOfDay(zoneId).toInstant().toEpochMilli();
        List<StatusPageHistory> todayStatusPageHistoryList = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), todayStartTimestamp, nowTimestamp);
        StatusPageHistory todayStatus = this.combineOneDayStatusPageHistory(todayStatusPageHistoryList, component, nowTimestamp);
        histories.add(todayStatus);
        long preTimestamp = now.atZone(zoneId).toLocalDate().minusDays(29L).atStartOfDay(zoneId).toInstant().toEpochMilli();
        List<StatusPageHistory> history = this.statusPageHistoryDao.findStatusPageHistoriesByComponentIdAndTimestampBetween(component.getId(), preTimestamp, todayStartTimestamp);
        LinkedList<StatusPageHistory> historyList = new LinkedList<StatusPageHistory>(history);
        historyList.sort((o1, o2) -> Long.compare(o1.getTimestamp(), o2.getTimestamp()));
        ZonedDateTime end = Instant.ofEpochMilli(todayStartTimestamp).atZone(zoneId).minusSeconds(1L);
        for (int i = 0; i < 29; ++i) {
            long endTimestamp = end.toInstant().toEpochMilli();
            long startTimestamp = end.toLocalDate().atStartOfDay(zoneId).toInstant().toEpochMilli();
            List<StatusPageHistory> thisDayHistory = historyList.stream().filter(h -> h.getTimestamp() >= startTimestamp && h.getTimestamp() <= endTimestamp).collect(Collectors.toList());
            if (thisDayHistory.isEmpty()) {
                histories.add(StatusPageHistory.builder().timestamp(Long.valueOf(endTimestamp)).componentId(component.getId()).state((byte)2).build());
            } else if (thisDayHistory.size() == 1) {
                histories.add((StatusPageHistory)thisDayHistory.get(0));
            } else {
                StatusPageHistory merged = this.combineOneDayStatusPageHistory(thisDayHistory, component, endTimestamp);
                histories.add(merged);
                this.statusPageHistoryDao.deleteAll(thisDayHistory);
                this.statusPageHistoryDao.save(merged);
            }
            end = end.minusDays(1L);
        }
        componentStatus.setHistory(histories);
        return componentStatus;
    }

    @Override
    public Page<StatusPageIncident> queryStatusPageIncidents(String search, Long startTime, Long endTime, int pageIndex, int pageSize) {
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> andList = new ArrayList<Predicate>();
            if (StringUtils.hasText((String)search)) {
                Predicate predicateName = criteriaBuilder.like(criteriaBuilder.lower((Expression)root.get("name")), "%" + search.toLowerCase() + "%");
                andList.add(predicateName);
            }
            if (startTime != null) {
                andList.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get("startTime"), (Comparable)startTime));
            }
            if (endTime != null) {
                andList.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get("endTime"), (Comparable)endTime));
            }
            Predicate[] predicates = new Predicate[andList.size()];
            return criteriaBuilder.and(andList.toArray(predicates));
        };
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"startTime"});
        PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)sort);
        return this.statusPageIncidentDao.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public StatusPageIncident queryStatusPageIncident(long id) {
        return this.statusPageIncidentDao.findById(id).orElse(null);
    }

    @Override
    public void newStatusPageIncident(StatusPageIncident statusPageIncident) {
        statusPageIncident.setStartTime(Long.valueOf(System.currentTimeMillis()));
        if (statusPageIncident.getState() == 3) {
            statusPageIncident.setEndTime(Long.valueOf(System.currentTimeMillis()));
        }
        this.statusPageIncidentDao.save(statusPageIncident);
    }

    @Override
    public void updateStatusPageIncident(StatusPageIncident statusPageIncident) {
        if (statusPageIncident.getState() == 3) {
            statusPageIncident.setEndTime(Long.valueOf(System.currentTimeMillis()));
        }
        this.statusPageIncidentDao.save(statusPageIncident);
    }

    @Override
    public void deleteStatusPageIncident(long id) {
        this.statusPageIncidentDao.deleteById(id);
    }

    public StatusPageServiceImpl(StatusPageIncidentComponentBindDao statusPageIncidentComponentBindDao) {
        this.statusPageIncidentComponentBindDao = statusPageIncidentComponentBindDao;
    }
}

