/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.PartitionFrame;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.std.Misc;

public abstract class AbstractFullPartitionFrameCursor
implements PartitionFrameCursor {
    protected final FullTablePartitionFrame frame = new FullTablePartitionFrame();
    protected PartitionDecoder parquetDecoder;
    protected int partitionHi;
    protected int partitionIndex;
    protected TableReader reader;

    @Override
    public void close() {
        if (this.reader != null && this.reader.isActive()) {
            this.reader = Misc.free(this.reader);
        }
        Misc.free(this.parquetDecoder);
    }

    @Override
    public SymbolMapReader getSymbolTable(int columnIndex) {
        return this.reader.getSymbolMapReader(columnIndex);
    }

    @Override
    public TableReader getTableReader() {
        return this.reader;
    }

    @Override
    public StaticSymbolTable newSymbolTable(int columnIndex) {
        return this.reader.newSymbolTable(columnIndex);
    }

    public PartitionFrameCursor of(TableReader reader) {
        this.partitionHi = reader.getPartitionCount();
        this.toTop();
        this.reader = reader;
        return this;
    }

    @Override
    public boolean reload() {
        boolean moreData = this.reader.reload();
        this.partitionHi = this.reader.getPartitionCount();
        this.toTop();
        return moreData;
    }

    @Override
    public long size() {
        return this.reader.size();
    }

    protected static class FullTablePartitionFrame
    implements PartitionFrame {
        protected byte format;
        protected PartitionDecoder parquetDecoder;
        protected int partitionIndex;
        protected long rowHi;
        protected long rowLo;

        protected FullTablePartitionFrame() {
        }

        @Override
        public PartitionDecoder getParquetDecoder() {
            return this.parquetDecoder;
        }

        @Override
        public byte getPartitionFormat() {
            return this.format;
        }

        @Override
        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public long getRowHi() {
            return this.rowHi;
        }

        @Override
        public long getRowLo() {
            return this.rowLo;
        }
    }
}

