/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.TableUtils;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.util.concurrent.atomic.AtomicLong;

public class IDGeneratorFactory {
    public static IDGenerator newIDGenerator(CairoConfiguration configuration, String uniqueIdFileName, int step) {
        if (configuration.getCommitMode() == 2) {
            return new NoSyncIDGenerator(configuration, uniqueIdFileName);
        }
        return new SyncIDGenerator(configuration, uniqueIdFileName, step);
    }

    static class NoSyncIDGenerator
    extends AbstractIDGenerator {
        public NoSyncIDGenerator(CairoConfiguration configuration, String uniqueIdFileName) {
            super(configuration, uniqueIdFileName);
        }

        @Override
        public long getNextId() {
            long next;
            long x = this.getCurrentId();
            while ((next = x) != (x = Os.compareAndSwap(this.uniqueIdMem, next, next + 1L))) {
            }
            return next + 1L;
        }
    }

    static class SyncIDGenerator
    extends AbstractIDGenerator {
        private final int step;
        private AtomicLong base;
        private long end;

        public SyncIDGenerator(CairoConfiguration configuration, String uniqueIdFileName, int step) {
            super(configuration, uniqueIdFileName);
            this.step = step;
        }

        @Override
        public long getCurrentId() {
            return this.base.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized long getNextId() {
            long next;
            while ((next = this.base.incrementAndGet()) > this.end) {
                SyncIDGenerator syncIDGenerator = this;
                synchronized (syncIDGenerator) {
                    if (this.base.get() > this.end) {
                        long newEnd = this.end + (long)this.step;
                        Unsafe.getUnsafe().putLong(this.uniqueIdMem, newEnd);
                        this.configuration.getFilesFacade().msync(this.uniqueIdMem, this.uniqueIdMemSize, this.configuration.getCommitMode() == 0);
                        this.base.set(newEnd - (long)this.step);
                        this.end = newEnd;
                    }
                }
            }
            return next;
        }

        @Override
        public void open(Path path) {
            super.open(path);
            this.end = super.getCurrentId();
            this.base = new AtomicLong(this.end);
        }
    }

    public static abstract class AbstractIDGenerator
    implements IDGenerator {
        protected final CairoConfiguration configuration;
        protected final String uniqueIdFileName;
        protected final long uniqueIdMemSize;
        protected long uniqueIdFd = -1L;
        protected long uniqueIdMem = 0L;

        public AbstractIDGenerator(CairoConfiguration configuration, String uniqueIdFileName) {
            this.configuration = configuration;
            this.uniqueIdFileName = uniqueIdFileName;
            this.uniqueIdMemSize = Files.PAGE_SIZE;
        }

        @Override
        public void close() {
            FilesFacade ff = this.configuration.getFilesFacade();
            if (this.uniqueIdMem != 0L) {
                ff.munmap(this.uniqueIdMem, this.uniqueIdMemSize, 0);
                this.uniqueIdMem = 0L;
            }
            if (ff.close(this.uniqueIdFd)) {
                this.uniqueIdFd = -1L;
            }
        }

        @Override
        public long getCurrentId() {
            assert (this.uniqueIdMem != 0L);
            return Unsafe.getUnsafe().getLong(this.uniqueIdMem);
        }

        @Override
        public void open(Path path) {
            this.close();
            if (path == null) {
                path = Path.getThreadLocal(this.configuration.getDbRoot());
            }
            int rootLen = path.size();
            try {
                path.concat(this.uniqueIdFileName);
                FilesFacade ff = this.configuration.getFilesFacade();
                this.uniqueIdFd = TableUtils.openFileRWOrFail(ff, path.$(), this.configuration.getWriterFileOpenOpts());
                this.uniqueIdMem = TableUtils.mapRW(ff, this.uniqueIdFd, this.uniqueIdMemSize, 0);
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
            finally {
                path.trimTo(rootLen);
            }
        }

        @Override
        public void reset() {
            Unsafe.getUnsafe().putLong(this.uniqueIdMem, 0L);
        }
    }
}

