/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpChunkedResponse;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpConstants;
import io.questdb.cutlass.http.HttpKeywords;
import io.questdb.cutlass.http.HttpRequestHandler;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;

public class TableStatusCheckProcessor
implements HttpRequestProcessor,
HttpRequestHandler,
Closeable {
    private static final Utf8Sequence DOES_NOT_EXIST = new Utf8String("Does not exist");
    private static final Utf8Sequence EXISTS = new Utf8String("Exists");
    private static final Utf8Sequence RESERVED_NAME = new Utf8String("Reserved name");
    private static final Utf8Sequence TABLE_NAME_MISSING = new Utf8String("table name missing");
    private final CairoEngine cairoEngine;
    private final String keepAliveHeader;
    private final Path path = new Path();
    private final byte requiredAuthType;
    private final StringSink utf16Sink = new StringSink();

    public TableStatusCheckProcessor(CairoEngine cairoEngine, JsonQueryProcessorConfiguration configuration) {
        this.cairoEngine = cairoEngine;
        this.keepAliveHeader = Chars.toString(configuration.getKeepAliveHeader());
        this.requiredAuthType = configuration.getRequiredAuthType();
    }

    @Override
    public void close() {
        Misc.free(this.path);
    }

    @Override
    public HttpRequestProcessor getProcessor(HttpRequestHeader requestHeader) {
        return this;
    }

    @Override
    public byte getRequiredAuthType() {
        return this.requiredAuthType;
    }

    @Override
    public void onRequestComplete(HttpConnectionContext context) throws PeerDisconnectedException, PeerIsSlowToReadException {
        DirectUtf8Sequence tableName = context.getRequestHeader().getUrlParam(HttpConstants.URL_PARAM_STATUS_TABLE_NAME);
        if (tableName == null) {
            context.simpleResponse().sendStatusTextContent(200, TABLE_NAME_MISSING, null);
        } else {
            int check = 1;
            this.utf16Sink.clear();
            if (Utf8s.utf8ToUtf16(tableName, this.utf16Sink)) {
                check = this.cairoEngine.getTableStatus(this.path, this.utf16Sink);
            }
            if (HttpKeywords.isJson(context.getRequestHeader().getUrlParam(HttpConstants.URL_PARAM_STATUS_FORMAT))) {
                HttpChunkedResponse response = context.getChunkedResponse();
                response.status(200, "application/json");
                response.headers().put(this.keepAliveHeader);
                response.sendHeader();
                ((Utf8Sink)((Utf8Sink)response.put('{').putAsciiQuoted("status")).putAscii(':').putQuoted(TableStatusCheckProcessor.toResponse(check))).putAscii('}');
                response.sendChunk(true);
            } else {
                context.simpleResponse().sendStatusTextContent(200, TableStatusCheckProcessor.toResponse(check), null);
            }
        }
    }

    private static Utf8Sequence toResponse(int existenceCheckResult) {
        switch (existenceCheckResult) {
            case 0: {
                return EXISTS;
            }
            case 1: {
                return DOES_NOT_EXIST;
            }
        }
        return RESERVED_NAME;
    }
}

