/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.client.Sender;
import io.questdb.cutlass.line.AbstractLineTcpSender;
import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.array.ArrayBufferAppender;
import io.questdb.cutlass.line.array.ArrayDataAppender;
import io.questdb.cutlass.line.array.ArrayShapeAppender;
import io.questdb.cutlass.line.array.DoubleArray;
import io.questdb.cutlass.line.array.FlattenArrayUtils;
import io.questdb.cutlass.line.array.LongArray;
import io.questdb.cutlass.line.tcp.PlainTcpLineChannel;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import org.jetbrains.annotations.NotNull;

public class LineTcpSenderV2
extends AbstractLineTcpSender
implements ArrayBufferAppender {
    public LineTcpSenderV2(LineChannel channel, int bufferCapacity, int maxNameLength) {
        super(channel, bufferCapacity, maxNameLength);
    }

    public static LineTcpSenderV2 newSender(int ip, int port, int bufferCapacity) {
        PlainTcpLineChannel channel = new PlainTcpLineChannel(NetworkFacadeImpl.INSTANCE, ip, port, bufferCapacity * 2);
        try {
            return new LineTcpSenderV2(channel, bufferCapacity, 127);
        }
        catch (Throwable t) {
            channel.close();
            throw t;
        }
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[] values) {
        return this.arrayColumn(name, (short)10, (byte)1, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[][] values) {
        return this.arrayColumn(name, (short)10, (byte)2, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[][][] values) {
        return this.arrayColumn(name, (short)10, (byte)3, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender doubleArray(CharSequence name, DoubleArray array) {
        if (this.processNullArray(name, array)) {
            return this;
        }
        this.writeFieldName(name).putAsciiInternal('=').put((byte)14).put((byte)10);
        array.appendToBufPtr(this);
        return this;
    }

    @Override
    public Sender doubleColumn(CharSequence name, double value) {
        this.writeFieldName(name).putAsciiInternal('=').put((byte)16);
        if (this.ptr + 8L >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putDouble(this.ptr, value);
        this.ptr += 8L;
        return this;
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[] values) {
        return this.arrayColumn(name, (short)6, (byte)1, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[][] values) {
        return this.arrayColumn(name, (short)6, (byte)2, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[][][] values) {
        return this.arrayColumn(name, (short)6, (byte)3, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, LongArray values) {
        if (this.processNullArray(name, values)) {
            return this;
        }
        this.writeFieldName(name).putAsciiInternal('=').put((byte)14).put((byte)6);
        values.appendToBufPtr(this);
        return this;
    }

    @Override
    public void putBlockOfBytes(long from, long len) {
        while (len > 0L) {
            if (this.ptr >= this.hi) {
                this.send00();
            }
            long copy = Math.min(len, this.hi - this.ptr);
            Vect.memcpy(this.ptr, from, copy);
            len -= copy;
            this.ptr += copy;
        }
    }

    @Override
    public void putByte(byte value) {
        this.put(value);
    }

    @Override
    public void putDouble(double value) {
        if (this.ptr + 8L >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putDouble(this.ptr, value);
        this.ptr += 8L;
    }

    @Override
    public void putInt(int value) {
        if (this.ptr + 4L >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putInt(this.ptr, value);
        this.ptr += 4L;
    }

    @Override
    public void putLong(long value) {
        if (this.ptr + 8L >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putLong(this.ptr, value);
        this.ptr += 8L;
    }

    private <T> Sender arrayColumn(CharSequence name, short columnType, byte nDims, T array, ArrayShapeAppender<T> shapeAppender, ArrayDataAppender<T> dataAppender) {
        if (this.processNullArray(name, array)) {
            return this;
        }
        this.writeFieldName(name).putAsciiInternal('=').put((byte)14).put((byte)columnType).put(nDims);
        shapeAppender.append(this, array);
        dataAppender.append(this, array);
        return this;
    }

    private boolean processNullArray(CharSequence name, Object value) {
        if (value == null) {
            this.writeFieldName(name).putAsciiInternal('=').put((byte)14).put((byte)33);
            return true;
        }
        return false;
    }
}

