/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class NullIfDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(DD)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new NullIfDoubleFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class NullIfDoubleFunction
    extends DoubleFunction
    implements BinaryFunction {
        private final Function doubleFunc1;
        private final Function doubleFunc2;

        public NullIfDoubleFunction(Function doubleFunc1, Function doubleFunc2) {
            this.doubleFunc1 = doubleFunc1;
            this.doubleFunc2 = doubleFunc2;
        }

        @Override
        public double getDouble(Record rec) {
            return Numbers.equals(this.doubleFunc1.getDouble(rec), this.doubleFunc2.getDouble(rec)) ? Double.NaN : this.doubleFunc1.getDouble(rec);
        }

        @Override
        public Function getLeft() {
            return this.doubleFunc1;
        }

        @Override
        public Function getRight() {
            return this.doubleFunc2;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("nullif(").val(this.doubleFunc1).val(',').val(this.doubleFunc2).val(')');
        }
    }
}

