/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.DateFormatUtils;

public class ToPgDateFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_pg_date(S)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        return new ToPgDateFunction(arg);
    }

    public static final class ToPgDateFunction
    extends DateFunction
    implements UnaryFunction {
        private final Function arg;

        public ToPgDateFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getDate(Record rec) {
            CharSequence value = this.arg.getStrA(rec);
            try {
                if (value != null) {
                    return DateFormatUtils.PG_DATE_FORMAT.parse(value, DateFormatUtils.EN_LOCALE);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            return Long.MIN_VALUE;
        }

        @Override
        public String getName() {
            return "to_pg_date";
        }
    }
}

