/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.date.ToTimestampVCFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;
import io.questdb.std.str.Utf8Sequence;

public final class VarcharToTimestampVCFunctionFactory
extends ToTimestampVCFunctionFactory {
    @Override
    public String getSignature() {
        return "to_timestamp(\u00d8s)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        CharSequence pattern = args.getQuick(1).getStrA(null);
        if (pattern == null) {
            throw SqlException.$(argPositions.getQuick(1), "pattern is required");
        }
        DateLocale defaultDateLocale = configuration.getDefaultDateLocale();
        if (arg.isConstant()) {
            return this.evaluateConstant(arg, TimestampFormatFactory.INSTANCE.get(pattern), defaultDateLocale);
        }
        if ("en".equals(defaultDateLocale.getName()) || defaultDateLocale.getName() != null && defaultDateLocale.getName().startsWith("en-")) {
            return new ToAsciiTimestampFuc(arg, TimestampFormatFactory.INSTANCE.get(pattern), defaultDateLocale);
        }
        return new ToTimestampVCFunctionFactory.Func(arg, TimestampFormatFactory.INSTANCE.get(pattern), defaultDateLocale);
    }

    protected static final class ToAsciiTimestampFuc
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;
        private final DateLocale locale;
        private final DateFormat timestampFormat;

        public ToAsciiTimestampFuc(Function arg, DateFormat timestampFormat, DateLocale locale) {
            this.arg = arg;
            this.timestampFormat = timestampFormat;
            this.locale = locale;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getTimestamp(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            try {
                if (value != null && value.isAscii()) {
                    return this.timestampFormat.parse(value.asAsciiCharSequence(), this.locale);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
            return Long.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("to_timestamp(").val(this.arg).val(')');
        }
    }
}

