/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.rnd.RndVarcharFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;

public class RndVarcharListFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_varchar(V)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args == null) {
            return new RndVarcharFunction(3, 10, 1);
        }
        ObjList<Utf8String> symbols = new ObjList<Utf8String>(args.size());
        RndVarcharListFunctionFactory.copyConstants(args, argPositions, symbols);
        return new RndVarcharListFunction(symbols);
    }

    static void copyConstants(ObjList<Function> args, IntList argPositions, ObjList<Utf8String> symbols) throws SqlException {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            Function f = args.getQuick(i);
            if (f.isConstant()) {
                short typeTag = ColumnType.tagOf(f.getType());
                if (typeTag == 11 || typeTag == 33) {
                    CharSequence value = f.getStrA(null);
                    symbols.add(value != null ? new Utf8String(value) : null);
                    continue;
                }
                if (typeTag == 4) {
                    char value = f.getChar(null);
                    symbols.add(value != '\u0000' ? new Utf8String(value) : null);
                    continue;
                }
            }
            throw SqlException.$(argPositions.getQuick(i), "STRING constant expected");
        }
    }

    private static final class RndVarcharListFunction
    extends VarcharFunction
    implements Function {
        private final int count;
        private final ObjList<Utf8String> symbols;
        private Rnd rnd;

        public RndVarcharListFunction(ObjList<Utf8String> symbols) {
            this.symbols = symbols;
            this.count = symbols.size();
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            return this.rndSymbol();
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            return this.rndSymbol();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_varchar(").val((Sinkable)this.symbols).val(')');
        }

        private Utf8String rndSymbol() {
            return this.symbols.getQuick(this.rnd.nextPositiveInt() % this.count);
        }
    }
}

