/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class StrPosFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "strpos(SS)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function substrFunc = args.getQuick(1);
        if (substrFunc.isConstant()) {
            CharSequence substr = substrFunc.getStrA(null);
            if (substr == null) {
                return IntConstant.NULL;
            }
            return new ConstFunc(args.getQuick(0), substr);
        }
        return new Func(args.getQuick(0), substrFunc);
    }

    private static int strpos(@NotNull CharSequence str, @NotNull CharSequence substr) {
        int substrLen = substr.length();
        if (substrLen < 1) {
            return 1;
        }
        int strLen = str.length();
        if (strLen < 1) {
            return 0;
        }
        int n = strLen - substrLen + 1;
        block0: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c != substr.charAt(0)) continue;
            for (int k = 1; k < substrLen; ++k) {
                if (str.charAt(i + k) != substr.charAt(k)) continue block0;
            }
            return i + 1;
        }
        return 0;
    }

    public static class ConstFunc
    extends IntFunction
    implements UnaryFunction {
        private final Function strFunc;
        private final CharSequence substr;

        public ConstFunc(Function strFunc, CharSequence substr) {
            this.strFunc = strFunc;
            this.substr = substr;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public int getInt(Record rec) {
            CharSequence str = this.strFunc.getStrA(rec);
            if (str == null) {
                return Integer.MIN_VALUE;
            }
            return StrPosFunctionFactory.strpos(str, this.substr);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("strpos(").val(this.strFunc).val(",'").val(this.substr).val("')");
        }
    }

    public static class Func
    extends IntFunction
    implements BinaryFunction {
        private final Function strFunc;
        private final Function substrFunc;

        public Func(Function strFunc, Function substrFunc) {
            this.strFunc = strFunc;
            this.substrFunc = substrFunc;
        }

        @Override
        public int getInt(Record rec) {
            CharSequence str = this.strFunc.getStrA(rec);
            if (str == null) {
                return Integer.MIN_VALUE;
            }
            CharSequence substr = this.substrFunc.getStrA(rec);
            if (substr == null) {
                return Integer.MIN_VALUE;
            }
            return StrPosFunctionFactory.strpos(str, substr);
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "strpos";
        }

        @Override
        public Function getRight() {
            return this.substrFunc;
        }
    }
}

