/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.MessageBus;
import io.questdb.cairo.sql.AtomicBooleanCircuitBreaker;
import io.questdb.cairo.sql.ExecutionCircuitBreaker;
import io.questdb.griffin.engine.table.AsyncGroupByAtom;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.tasks.GroupByMergeShardTask;
import java.util.concurrent.atomic.AtomicInteger;

public class GroupByMergeShardJob
extends AbstractQueueConsumerJob<GroupByMergeShardTask> {
    private static final Log LOG = LogFactory.getLog(GroupByMergeShardJob.class);

    public GroupByMergeShardJob(MessageBus messageBus) {
        super(messageBus.getGroupByMergeShardQueue(), messageBus.getGroupByMergeShardSubSeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(int workerId, GroupByMergeShardTask task, Sequence subSeq, long cursor, AsyncGroupByAtom stealingAtom) {
        AtomicBooleanCircuitBreaker circuitBreaker = task.getCircuitBreaker();
        AtomicInteger startedCounter = task.getStartedCounter();
        CountDownLatchSPI doneLatch = task.getDoneLatch();
        AsyncGroupByAtom atom = task.getAtom();
        int shardIndex = task.getShardIndex();
        task.clear();
        subSeq.done(cursor);
        startedCounter.incrementAndGet();
        boolean owner = stealingAtom != null && stealingAtom == atom;
        try {
            int slotId = atom.maybeAcquire(workerId, owner, (ExecutionCircuitBreaker)circuitBreaker);
            try {
                if (circuitBreaker.checkIfTripped()) {
                    return;
                }
                atom.mergeShard(slotId, shardIndex);
            }
            finally {
                atom.release(slotId);
            }
        }
        catch (Throwable th) {
            LOG.error().$("merge shard failed [error=").$(th).I$();
            circuitBreaker.cancel();
        }
        finally {
            doneLatch.countDown();
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        GroupByMergeShardTask task = (GroupByMergeShardTask)this.queue.get(cursor);
        GroupByMergeShardJob.run(workerId, task, this.subSeq, cursor, null);
        return true;
    }
}

