/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;

public class AsOfJoinLightRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final AsOfLightJoinRecordCursor cursor;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final long toleranceInterval;

    public AsOfJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit, JoinContext joinContext, long toleranceInterval) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        try {
            this.masterKeySink = masterKeySink;
            this.slaveKeySink = slaveKeySink;
            this.toleranceInterval = toleranceInterval;
            Map joinKeyMap = MapFactory.createUnorderedMap(configuration, joinColumnTypes, valueTypes);
            this.cursor = new AsOfLightJoinRecordCursor(columnSplit, joinKeyMap, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex());
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = null;
        try {
            slaveCursor = this.slaveFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor);
        }
        catch (Throwable ex) {
            Misc.free(masterCursor);
            Misc.free(slaveCursor);
            throw ex;
        }
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("AsOf Join Light");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child(this.slaveFactory);
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
    }

    private class AsOfLightJoinRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final int masterTimestampIndex;
        private final OuterJoinRecord record;
        private final int slaveTimestampIndex;
        private boolean isMasterHasNextPending;
        private boolean isOpen;
        private long lastSlaveRowID;
        private boolean masterHasNext;
        private Record masterRecord;
        private Record slaveRecord;
        private long slaveTimestamp;

        public AsOfLightJoinRecordCursor(int columnSplit, Map joinKeyMap, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex) {
            super(columnSplit);
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.slaveTimestamp = Long.MIN_VALUE;
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.joinKeyMap = joinKeyMap;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
            this.isOpen = true;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            this.masterCursor.calculateSize(circuitBreaker, counter);
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.isMasterHasNextPending) {
                this.masterHasNext = this.masterCursor.hasNext();
                this.isMasterHasNextPending = false;
            }
            if (this.masterHasNext) {
                MapValue value;
                MapKey key;
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                long minSlaveTimestamp = AsOfJoinLightRecordCursorFactory.this.toleranceInterval == Long.MIN_VALUE ? Long.MIN_VALUE : masterTimestamp - AsOfJoinLightRecordCursorFactory.this.toleranceInterval;
                long slaveTimestamp = this.slaveTimestamp;
                long slaveRowID = this.lastSlaveRowID;
                if (slaveTimestamp <= masterTimestamp) {
                    if (this.lastSlaveRowID != Long.MIN_VALUE) {
                        this.slaveCursor.recordAt(this.slaveRecord, this.lastSlaveRowID);
                        slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
                        if (slaveTimestamp >= minSlaveTimestamp) {
                            key = this.joinKeyMap.withKey();
                            key.put(this.slaveRecord, AsOfJoinLightRecordCursorFactory.this.slaveKeySink);
                            value = key.createValue();
                            value.putLong(0, this.lastSlaveRowID);
                        }
                    }
                    Record rec = this.slaveCursor.getRecord();
                    while (this.slaveCursor.hasNext()) {
                        slaveTimestamp = rec.getTimestamp(this.slaveTimestampIndex);
                        slaveRowID = rec.getRowId();
                        if (slaveTimestamp > masterTimestamp) break;
                        if (slaveTimestamp < minSlaveTimestamp) continue;
                        key = this.joinKeyMap.withKey();
                        key.put(rec, AsOfJoinLightRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        value.putLong(0, rec.getRowId());
                    }
                    this.slaveTimestamp = slaveTimestamp;
                    this.lastSlaveRowID = slaveRowID;
                }
                key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, AsOfJoinLightRecordCursorFactory.this.masterKeySink);
                value = key.findValue();
                if (value != null) {
                    this.slaveCursor.recordAt(this.slaveRecord, value.getLong(0));
                    slaveTimestamp = this.slaveRecord.getTimestamp(this.slaveTimestampIndex);
                    this.record.hasSlave(AsOfJoinLightRecordCursorFactory.this.toleranceInterval == Long.MIN_VALUE || slaveTimestamp >= masterTimestamp - AsOfJoinLightRecordCursorFactory.this.toleranceInterval);
                } else {
                    this.record.hasSlave(false);
                }
                this.isMasterHasNextPending = true;
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return this.masterCursor.preComputedStateSize() + this.slaveCursor.preComputedStateSize();
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public void toTop() {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
            this.isMasterHasNextPending = true;
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
            }
            this.slaveTimestamp = Long.MIN_VALUE;
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
            this.isMasterHasNextPending = true;
        }
    }
}

