/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table.parquet;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.griffin.engine.table.parquet.PartitionDescriptor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Os;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;

public class PartitionUpdater
implements QuietCloseable {
    private static final Log LOG = LogFactory.getLog(PartitionUpdater.class);
    private final FilesFacade ff;
    private long ptr;

    public PartitionUpdater(FilesFacade ff) {
        this.ff = ff;
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void of(LPSZ srcPath, int fileOpenOpts, long fileSize, int timestampIndex, long compressionCodec, boolean statisticsEnabled, boolean rawArrayEncoding, long rowGroupSize, long dataPageSize) {
        long allocator = Unsafe.getNativeAllocator(66);
        this.destroy();
        this.ptr = PartitionUpdater.create(allocator, srcPath.size(), srcPath.ptr(), Files.detach(TableUtils.openRW(this.ff, srcPath, LOG, fileOpenOpts)), fileSize, timestampIndex, compressionCodec, statisticsEnabled, rawArrayEncoding, rowGroupSize, dataPageSize);
    }

    public void updateFileMetadata() {
        assert (this.ptr != 0L);
        PartitionUpdater.updateFileMetadata(this.ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRowGroup(short rowGroupId, PartitionDescriptor descriptor) {
        int columnCount = descriptor.getColumnCount();
        long rowCount = descriptor.getPartitionRowCount();
        int timestampIndex = descriptor.getTimestampIndex();
        try {
            assert (this.ptr != 0L);
            PartitionUpdater.updateRowGroup(this.ptr, descriptor.tableName.size(), descriptor.tableName.ptr(), rowGroupId, columnCount, descriptor.getColumnNamesPtr(), descriptor.getColumnNamesLen(), descriptor.getColumnDataPtr(), descriptor.getColumnDataLen(), timestampIndex, rowCount);
        }
        finally {
            descriptor.clear();
        }
    }

    private static native long create(long var0, int var2, long var3, int var5, long var6, int var8, long var9, boolean var11, boolean var12, long var13, long var15) throws CairoException;

    private static native void destroy(long var0);

    private static native void updateFileMetadata(long var0);

    private static native void updateRowGroup(long var0, int var2, long var3, short var5, int var6, long var7, int var9, long var10, long var12, int var14, long var15) throws CairoException;

    private void destroy() {
        if (this.ptr != 0L) {
            try {
                PartitionUpdater.destroy(this.ptr);
            }
            finally {
                this.ptr = 0L;
            }
        }
    }

    static {
        Os.init();
    }
}

