/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.ConcurrentQueueSegment;
import io.questdb.mp.ConcurrentSegmentManipulator;
import io.questdb.mp.Queue;
import io.questdb.mp.ValueHolder;
import io.questdb.std.ObjectFactory;

public class ConcurrentQueue<T>
implements Queue<T> {
    private static final int INITIAL_SEGMENT_LENGTH = 32;
    private static final int MAX_SEGMENT_LENGTH = 0x100000;
    private final Object crossSegmentLock = new Object();
    private final ObjectFactory<T> factory;
    private final ConcurrentSegmentManipulator<T> queueManipulator;
    private volatile ConcurrentQueueSegment<T> head;
    private volatile ConcurrentQueueSegment<T> tail;

    public ConcurrentQueue(ObjectFactory<T> factory, ConcurrentSegmentManipulator<T> queueManipulator) {
        this(factory, queueManipulator, 32);
    }

    public ConcurrentQueue(ObjectFactory<T> factory, ConcurrentSegmentManipulator<T> queueManipulator, int size) {
        assert ((size & size - 1) == 0);
        this.factory = factory;
        this.head = new ConcurrentQueueSegment<T>(factory, queueManipulator, 32);
        this.tail = this.head;
        this.queueManipulator = queueManipulator;
    }

    public static <T extends ValueHolder<T>> ConcurrentQueue<T> createConcurrentQueue(ObjectFactory<T> factory) {
        return new ConcurrentQueue<T>(factory, new ValueHolderManipulator());
    }

    public int capacity() {
        return this.tail.getCapacity();
    }

    @Override
    public void clear() {
        T tmp = this.factory.newInstance();
        while (this.tryDequeue(tmp)) {
        }
    }

    @Override
    public void enqueue(T item) {
        if (!this.tail.tryEnqueue(item)) {
            this.enqueueSlow(item);
        }
    }

    @Override
    public boolean tryDequeue(T target) {
        T val = this.tryDequeueValue(target);
        return val != null;
    }

    public T tryDequeueValue(T maybeTarget) {
        ConcurrentQueueSegment<T> head = this.head;
        T val = head.tryDequeue(maybeTarget);
        if (val != null) {
            return val;
        }
        if (head.nextSegment == null) {
            return null;
        }
        return this.tryDequeueSlow(maybeTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueSlow(T item) {
        ConcurrentQueueSegment<T> tail;
        while (!(tail = this.tail).tryEnqueue(item)) {
            Object object = this.crossSegmentLock;
            synchronized (object) {
                if (tail == this.tail) {
                    tail.ensureFrozenForEnqueues();
                    int nextSize = Math.min(tail.getCapacity() * 2, 0x100000);
                    ConcurrentQueueSegment<T> newTail = new ConcurrentQueueSegment<T>(this.factory, this.queueManipulator, nextSize);
                    tail.nextSegment = newTail;
                    this.tail = newTail;
                }
            }
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T tryDequeueSlow(T container) {
        ConcurrentQueueSegment<T> head;
        T val;
        while ((val = (head = this.head).tryDequeue(container)) == null) {
            if (head.nextSegment == null) {
                return null;
            }
            assert (head.frozenForEnqueues);
            val = head.tryDequeue(container);
            if (val != null) {
                return val;
            }
            Object object = this.crossSegmentLock;
            synchronized (object) {
                if (head == this.head) {
                    this.head = head.nextSegment;
                }
            }
        }
        return val;
    }

    private static class ValueHolderManipulator<T extends ValueHolder<T>>
    implements ConcurrentSegmentManipulator<T> {
        private ValueHolderManipulator() {
        }

        @Override
        public T dequeue(ConcurrentQueueSegment.Slot<T>[] slots, int slotsIndex, T target) {
            ((ValueHolder)slots[slotsIndex].item).copyTo(target);
            return target;
        }

        @Override
        public void enqueue(T item, ConcurrentQueueSegment.Slot<T>[] slots, int slotsIndex) {
            item.copyTo((ValueHolder)((ValueHolder)slots[slotsIndex].item));
        }
    }
}

