/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import java.util.Arrays;

public class BitSet
implements Mutable {
    public static final int BITS_PER_WORD = 64;
    private final int initialNBits;
    private long[] words;

    public BitSet() {
        this(1024);
    }

    public BitSet(int nBits) {
        this.initialNBits = nBits;
        this.words = new long[BitSet.wordIndex(nBits - 1) + 1];
    }

    public long capacity() {
        return (long)this.words.length * 64L;
    }

    @Override
    public void clear() {
        Arrays.fill(this.words, 0L);
    }

    public boolean get(int bitIndex) {
        int wordIndex = BitSet.wordIndex(bitIndex);
        return wordIndex < this.words.length && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public boolean getAndSet(int bitIndex) {
        int wordIndex = BitSet.wordIndex(bitIndex);
        this.checkCapacity(wordIndex + 1);
        boolean old = (this.words[wordIndex] & 1L << bitIndex) != 0L;
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << bitIndex;
        return old;
    }

    public void resetCapacity() {
        this.words = new long[BitSet.wordIndex(this.initialNBits - 1) + 1];
    }

    public void set(int bitIndex) {
        int wordIndex = BitSet.wordIndex(bitIndex);
        this.checkCapacity(wordIndex + 1);
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << bitIndex;
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void checkCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int newLen = Math.max(2 * this.words.length, wordsRequired);
            this.words = Arrays.copyOf(this.words, newLen);
        }
    }
}

