/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class ObjStack<T>
implements Mutable {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final int initialCapacity;
    private int bottom;
    private T[] elements;
    private int head;
    private int mask;
    private int tail;

    public ObjStack() {
        this(16);
    }

    public ObjStack(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.allocateElements(initialCapacity);
    }

    @Override
    public void clear() {
        if (this.head != this.tail) {
            this.tail = 0;
            this.head = 0;
            Arrays.fill(this.elements, null);
            this.bottom = 0;
        }
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getCapacity() {
        return this.elements.length;
    }

    public boolean notEmpty() {
        return this.size() > 0;
    }

    public T peek() {
        return this.peek(0);
    }

    public T peek(int n) {
        return n < this.size() ? (T)this.elements[this.head + n & this.mask] : null;
    }

    public T pop() {
        if (this.size() == 0) {
            return null;
        }
        int h = this.head;
        T result = this.elements[h];
        if (result == null) {
            return null;
        }
        this.elements[h] = null;
        this.head = h + 1 & this.mask;
        return result;
    }

    public void push(T e) {
        this.head = this.head - 1 & this.mask;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void resetCapacity() {
        int n = this.elements.length;
        if (n > this.initialCapacity) {
            int h = this.head;
            int size = this.size();
            int newCapacity = this.initialCapacity;
            Object[] next = new Object[newCapacity];
            int maxCopy = newCapacity - 1;
            if (size > 0) {
                int t = h + size & this.mask;
                if (this.head < t) {
                    System.arraycopy(this.elements, h, next, 0, Math.min(size, maxCopy));
                } else {
                    int r = Math.min(n - h, maxCopy);
                    System.arraycopy(this.elements, h, next, 0, r);
                    if (r < maxCopy && t < this.head) {
                        System.arraycopy(this.elements, 0, next, r, Math.min(t, maxCopy - r));
                    }
                }
            }
            this.head = 0;
            this.tail = Math.min(size, maxCopy);
            this.elements = next;
            this.mask = maxCopy;
        }
    }

    public void setBottom(int bottom) {
        if (bottom > this.sizeRaw()) {
            throw new IllegalStateException("Tried to set bottom beyond the top of the stack");
        }
        this.bottom = bottom;
    }

    public int size() {
        return this.sizeRaw() - this.bottom;
    }

    public int sizeRaw() {
        return this.tail - this.head & this.mask;
    }

    public void update(T e) {
        this.update(0, e);
    }

    public void update(int n, T e) {
        if (n >= this.size()) {
            throw new IllegalStateException("Tried to update under the bottom");
        }
        this.elements[this.head + n & this.mask] = e;
    }

    private void allocateElements(int capacity) {
        capacity = Numbers.ceilPow2(capacity);
        this.elements = new Object[capacity];
        this.mask = capacity - 1;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int h = this.head;
        int n = this.elements.length;
        int r = n - h;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Stack is too big");
        }
        Object[] next = new Object[newCapacity];
        System.arraycopy(this.elements, h, next, 0, r);
        System.arraycopy(this.elements, 0, next, r, h);
        this.elements = next;
        this.head = 0;
        this.tail = n;
        this.mask = newCapacity - 1;
    }
}

