/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import java.util.Collections;
import java.util.List;

public class Rnd {
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private final StringSink array = new StringSink();
    private long s0;
    private long s1;

    public Rnd(long s0, long s1) {
        this.reset(s0, s1);
    }

    public Rnd() {
        this.reset();
    }

    public long getSeed0() {
        return this.s0;
    }

    public long getSeed1() {
        return this.s1;
    }

    public boolean nextBoolean() {
        return this.nextLong() >>> 63 != 0L;
    }

    public byte nextByte() {
        return (byte)this.nextLong();
    }

    public byte[] nextBytes(int len) {
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)(this.nextPositiveInt() % 25 + 66);
        }
        return bytes;
    }

    public void nextBytes(byte[] bytes) {
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)(this.nextPositiveInt() % 25 + 66);
        }
    }

    public char nextChar() {
        return (char)(this.nextPositiveInt() % 25 + 66);
    }

    public void nextChars(long address, int len) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(address + (long)i * 2L, this.nextChar());
        }
    }

    public CharSequence nextChars(int len) {
        this.array.clear();
        this.nextChars(this.array, len);
        return this.array;
    }

    public void nextChars(Utf16Sink array, int len) {
        for (int i = 0; i < len; ++i) {
            array.put((char)(this.nextPositiveInt() % 25 + 66));
        }
    }

    public double nextDouble() {
        return (double)(((long)this.nextIntForDouble(26) << 27) + (long)this.nextIntForDouble(27)) * (double)1.110223E-16f;
    }

    public void nextDoubleArray(int maxDimCount, DirectArray array, int nanRate, int maxDimLen, int errorPosition) {
        int dimCount = this.nextIntExp(maxDimCount - 1) + 1;
        array.setType(ColumnType.encodeArrayType((short)10, dimCount));
        int size = 1;
        for (int i = 0; i < dimCount; ++i) {
            int n = this.nextIntExp(maxDimLen) + 1;
            array.setDimLen(i, n);
            size *= n;
        }
        array.applyShape(errorPosition);
        this.nextFlatDoubleArray(array, nanRate, size);
    }

    public void nextDoubleArray(int dimCount, DirectArray array, int nanRate, IntList dimLens, int errorPosition) {
        assert (dimLens.size() == dimCount);
        array.setType(ColumnType.encodeArrayType((short)10, dimCount));
        int size = 1;
        for (int i = 0; i < dimCount; ++i) {
            int n = dimLens.getQuick(i);
            array.setDimLen(i, n);
            size *= n;
        }
        array.applyShape(errorPosition);
        this.nextFlatDoubleArray(array, nanRate, size);
    }

    public void nextFlatDoubleArray(DirectArray array, int nanRate, int size) {
        MemoryA memA = array.startMemoryA();
        for (int i = 0; i < size; ++i) {
            double val = nanRate > 0 && this.nextInt(nanRate) == 0 ? Double.NaN : this.nextDouble();
            memA.putDouble(val);
        }
    }

    public float nextFloat() {
        return (float)this.nextIntForDouble(24) * 5.9604645E-8f;
    }

    public long nextGeoHash(int bits) {
        double x = this.nextDouble() * 180.0 - 90.0;
        double y = this.nextDouble() * 360.0 - 180.0;
        try {
            return GeoHashes.fromCoordinatesDeg(x, y, bits);
        }
        catch (NumericException e) {
            return -1L;
        }
    }

    public byte nextGeoHashByte(int bits) {
        return (byte)this.nextGeoHash(bits);
    }

    public int nextGeoHashInt(int bits) {
        return (int)this.nextGeoHash(bits);
    }

    public long nextGeoHashLong(int bits) {
        return this.nextGeoHash(bits);
    }

    public short nextGeoHashShort(int bits) {
        return (short)this.nextGeoHash(bits);
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int boundary) {
        return this.nextPositiveInt() % boundary;
    }

    public long nextLong(long boundary) {
        return this.nextPositiveLong() % boundary;
    }

    public long nextLong() {
        long l0;
        long l1 = this.s0;
        this.s0 = l0 = this.s1;
        l1 ^= l1 << 23;
        this.s1 = l1 ^ l0 ^ l1 >> 17 ^ l0 >> 26;
        return this.s1 + l0;
    }

    public void nextLongArray(int dimCount, DirectArray array, int nanRate, int maxDimLen, int errorPosition) {
        array.setType(ColumnType.encodeArrayType((short)6, dimCount));
        int size = 1;
        for (int i = 0; i < dimCount; ++i) {
            int n = this.nextInt(maxDimLen - 1) + 1;
            array.setDimLen(i, n);
            size *= n;
        }
        array.applyShape(errorPosition);
        MemoryA memA = array.startMemoryA();
        for (int i = 0; i < size; ++i) {
            long val = nanRate > 0 && this.nextInt(nanRate) == 1 ? Long.MIN_VALUE : this.nextLong();
            memA.putLong(val);
        }
    }

    public int nextPositiveInt() {
        int n = (int)this.nextLong();
        return n > 0 ? n : (n == Integer.MIN_VALUE ? Integer.MAX_VALUE : -n);
    }

    public long nextPositiveLong() {
        long l = this.nextLong();
        return l > 0L ? l : (l == Long.MIN_VALUE ? Long.MAX_VALUE : -l);
    }

    public short nextShort() {
        return (short)this.nextLong();
    }

    public String nextString(int len) {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(this.nextPositiveInt() % 25 + 66);
        }
        return new String(chars);
    }

    public void nextUtf8AsciiStr(int len, Utf8Sink array) {
        for (int i = 0; i < len; ++i) {
            array.putAscii((char)(32 + this.nextPositiveInt() % 95));
        }
    }

    public void nextUtf8Str(int len, Utf8Sink array) {
        block6: for (int i = 0; i < len; ++i) {
            int byteCount = Math.max(1, this.nextInt(5));
            switch (byteCount) {
                case 1: {
                    array.putAscii((char)(32 + this.nextPositiveInt() % 95));
                    continue block6;
                }
                case 2: {
                    byte b2;
                    byte b1;
                    do {
                        b1 = this.nextUtf8Byte(224, 192);
                        b2 = this.nextUtf8ContinuationByte();
                    } while ((b1 & 0x1E) == 0);
                    array.put(b1).put(b2);
                    continue block6;
                }
                case 3: {
                    byte b3;
                    char c;
                    byte b2;
                    byte b1;
                    while (Character.isSurrogate(c = Utf8s.utf8ToChar(b1 = this.nextUtf8Byte(240, 224), b2 = this.nextUtf8ContinuationByte(), b3 = this.nextUtf8ContinuationByte()))) {
                    }
                    array.put(b1).put(b2).put(b3);
                    continue block6;
                }
                case 4: {
                    byte b4;
                    byte b3;
                    byte b2;
                    byte b1;
                    while (!Character.isSupplementaryCodePoint(Utf8s.getUtf8Codepoint(b1 = this.nextUtf8Byte(248, 240), b2 = this.nextUtf8ContinuationByte(), b3 = this.nextUtf8ContinuationByte(), b4 = this.nextUtf8ContinuationByte()))) {
                    }
                    array.put(b1).put(b2).put(b3).put(b4);
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    public final void reset(long s0, long s1) {
        this.s0 = s0;
        this.s1 = s1;
    }

    public final void reset() {
        this.reset(-559038737L, -555433747L);
    }

    public void shuffle(List<?> list) {
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            int swapTarget = this.nextInt(i + 1);
            Collections.swap(list, i, swapTarget);
        }
    }

    public void syncWith(Rnd other) {
        this.s0 = other.s0;
        this.s1 = other.s1;
    }

    private int nextIntExp(int boundary) {
        return (int)Math.exp(this.nextDouble() * Math.log(boundary));
    }

    private int nextIntForDouble(int bits) {
        return (int)((this.nextLong() & 0xFFFFFFFFFFFFL) >>> 48 - bits);
    }

    private byte nextUtf8Byte(int wipe, int set) {
        do {
            int k = this.nextInt();
            k &= ~wipe;
        } while ((k &= 0xFF) == 0);
        return (byte)(k |= set);
    }

    private byte nextUtf8ContinuationByte() {
        return this.nextUtf8Byte(192, 128);
    }
}

