/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.BinarySequence;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Digest
implements Utf8Sink {
    private final MessageDigest digest;
    private final byte[] buffer;

    public Digest(@NotNull DigestAlgorithm algorithm) {
        String algo;
        switch (algorithm) {
            case MD5: {
                algo = "MD5";
                break;
            }
            case SHA1: {
                algo = "SHA-1";
                break;
            }
            default: {
                algo = "SHA-256";
            }
        }
        try {
            this.digest = MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("unreachable");
        }
        this.buffer = new byte[this.digest.getDigestLength()];
    }

    @Override
    public Utf8Sink put(@Nullable Utf8Sequence us) {
        if (us != null) {
            int n = us.size();
            for (int i = 0; i < n; ++i) {
                this.digest.update(us.byteAt(i));
            }
        }
        return this;
    }

    @Override
    public Utf8Sink put(byte b) {
        this.digest.update(b);
        return this;
    }

    @Override
    public Utf8Sink putNonAscii(long lo, long hi) {
        for (long p = lo; p < hi; ++p) {
            this.digest.update(Unsafe.getUnsafe().getByte(p));
        }
        return this;
    }

    public void hash(@NotNull BinarySequence sequence, @NotNull CharSink<?> sink) {
        int i = 0;
        while ((long)i < sequence.length()) {
            this.digest.update(sequence.byteAt(i));
            ++i;
        }
        try {
            this.digest.digest(this.buffer, 0, this.buffer.length);
        }
        catch (DigestException e) {
            throw new RuntimeException("unreachable");
        }
        this.hexencode(sink);
    }

    public void hash(@NotNull CharSequence sequence, @NotNull CharSink<?> sink) {
        this.put(sequence);
        try {
            this.digest.digest(this.buffer, 0, this.buffer.length);
        }
        catch (DigestException e) {
            throw new RuntimeException("unreachable");
        }
        this.hexencode(sink);
    }

    public void hash(@NotNull Utf8Sequence sequence, @NotNull CharSink<?> sink) {
        this.put(sequence);
        try {
            this.digest.digest(this.buffer, 0, this.buffer.length);
        }
        catch (DigestException e) {
            throw new RuntimeException("unreachable");
        }
        this.hexencode(sink);
    }

    private void hexencode(@NotNull CharSink<?> sink) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (byte b : this.buffer) {
            sink.put(hexChars[(0xF0 & b) >> 4]);
            sink.put(hexChars[0xF & b]);
        }
    }

    public static enum DigestAlgorithm {
        MD5,
        SHA1,
        SHA256;

    }
}

