/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client.handler;

import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.handler.ResponseHandler;
import com.alibaba.nacos.common.http.client.response.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.utils.IoUtils;
import java.lang.reflect.Type;

public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    private Type responseType;

    @Override
    public final void setResponseType(Type responseType) {
        this.responseType = responseType;
    }

    @Override
    public final HttpRestResult<T> handle(HttpClientResponse response) throws Exception {
        if (200 != response.getStatusCode()) {
            return this.handleError(response);
        }
        return this.convertResult(response, this.responseType);
    }

    private HttpRestResult<T> handleError(HttpClientResponse response) throws Exception {
        Header headers = response.getHeaders();
        String message = IoUtils.toString(response.getBody(), headers.getCharset());
        return new HttpRestResult<Object>(headers, response.getStatusCode(), null, message);
    }

    public abstract HttpRestResult<T> convertResult(HttpClientResponse var1, Type var2) throws Exception;
}

