/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.Collection;
import java.util.List;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;

public class HeaderContentTypeResolver
implements RequestedContentTypeResolver {
    @Override
    public List<MediaType> resolveMediaTypes(ServerWebExchange exchange2) throws NotAcceptableStatusException {
        try {
            List mediaTypes = exchange2.getRequest().getHeaders().getAccept();
            MimeTypeUtils.sortBySpecificity((List)mediaTypes);
            return !CollectionUtils.isEmpty((Collection)mediaTypes) ? mediaTypes : MEDIA_TYPE_ALL_LIST;
        }
        catch (InvalidMediaTypeException ex) {
            String value = exchange2.getRequest().getHeaders().getFirst("Accept");
            throw new NotAcceptableStatusException("Could not parse 'Accept' header [" + value + "]: " + ex.getMessage());
        }
    }
}

