/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import org.apache.hc.core5.net.InetAddressUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestInetAddressUtils {
    TestInetAddressUtils() {
    }

    @Test
    void testValidIPv4Address() {
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4((CharSequence)"127.0.0.1"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4((CharSequence)"192.168.0.0"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4((CharSequence)"255.255.255.255"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4((CharSequence)"0.168.0.0"));
    }

    @Test
    void testInvalidIPv4Address() {
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4((CharSequence)" 127.0.0.1 "));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4((CharSequence)"g.ar.ba.ge"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4((CharSequence)"192.168.0"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4((CharSequence)"256.255.255.255"));
    }

    @Test
    void testValidIPv6Address() {
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6Std((CharSequence)"2001:0db8:0000:0000:0000:0000:1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6Std((CharSequence)"2001:db8:0:0:0:0:1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6Std((CharSequence)"0:0:0:0:0:0:0:0"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6Std((CharSequence)"0:0:0:0:0:0:0:1"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"2001:0db8:0:0::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"2001:0db8::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"2001:db8::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"::1"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"::"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8:0000:0000:0000:0000:1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:db8:0:0:0:0:1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"0:0:0:0:0:0:0:0"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"0:0:0:0:0:0:0:1"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8:0:0::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:db8::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"::1"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"::"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%eth2"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%3"));
    }

    @Test
    void testInvalidIPv6Address() {
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8:0000:garb:age0:0000:1428:57ab"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0gb8:0000:0000:0000:0000:1428:57ab"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6Std((CharSequence)"0:0:0:0:0:0:0:0:0"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6Std((CharSequence)"0:0:0:0:0:0:0"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)":1"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)":1"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8::0000::57ab"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"1:2:3:4:5:6:7::9"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"1::3:4:5:6:7:8:9"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"::3:4:5:6:7:8:9"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)""));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%eth2#"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%3@"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a#eth2"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%eth2!"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8:0:0::1428:57ab%"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8:0:0::1428:57ab%eth2#"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%eth2#3"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8:0:0::1428:57ab%eth2#3"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"fe80::1ff:fe23:4567:890a%3#eth2"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6((CharSequence)"2001:0db8:0:0::1428:57ab%3#eth2"));
    }

    @Test
    void testValidIPv6BracketAddress() {
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:0db8:0000:0000:0000:0000:1428:57ab]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:db8:0:0:0:0:1428:57ab]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[0:0:0:0:0:0:0:0]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[0:0:0:0:0:0:0:1]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:0db8:0:0::1428:57ab]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:0db8::1428:57ab]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:db8::1428:57ab]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[::1]"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[::]"));
    }

    @Test
    void testInvalidIPv6BracketAddress() {
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"2001:0db8:0000:garb:age0:0000:1428:57ab"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:0db8:0000:garb:age0:0000:1428:57ab]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"2001:0gb8:0000:0000:0000:0000:1428:57ab"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:0gb8:0000:0000:0000:0000:1428:57ab]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"0:0:0:0:0:0:0:0:0"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[0:0:0:0:0:0:0:0:0]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"0:0:0:0:0:0:0"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[0:0:0:0:0:0:0]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)":1"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[:1]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"2001:0db8::0000::57ab"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[2001:0db8::0000::57ab]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"1:2:3:4:5:6:7::9"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[1:2:3:4:5:6:7::9]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"1::3:4:5:6:7:8:9"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[1::3:4:5:6:7:8:9]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"::3:4:5:6:7:8:9"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[::3:4:5:6:7:8:9]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)""));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"[]"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"::"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"::1"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6URLBracketed((CharSequence)"2001:db8::1428:57ab"));
    }

    @Test
    void testInvalidIPv6AddressIncorrectGroupCount() {
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"1:2::4:5:6:7:8:9"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv6HexCompressed((CharSequence)"1:2:3:4:5:6::8:9"));
    }

    @Test
    void testHasValidIPv6ColonCount() {
        Assertions.assertFalse((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)""));
        Assertions.assertFalse((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)":"));
        Assertions.assertFalse((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"127.0.0.1"));
        Assertions.assertFalse((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)":0"));
        Assertions.assertFalse((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"0:"));
        Assertions.assertFalse((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"1:2:3:4:5:6:7:8:"));
        Assertions.assertFalse((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"1:2:3:4:5:6:7:8:9"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"2001:0db8:0000:0000:0000:0000:1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"2001:db8:0:0:0:0:1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"0:0:0:0:0:0:0:0"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"0:0:0:0:0:0:0:1"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"2001:0db8:0:0::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"2001:0db8::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"2001:db8::1428:57ab"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"::1"));
        Assertions.assertTrue((boolean)InetAddressUtils.hasValidIPv6ColonCount((CharSequence)"::"));
    }

    @Test
    void testValidIPv4MappedIPv6Address() {
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::FFFF:1.2.3.4"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::ffff:255.255.255.255"));
    }

    @Test
    void testInValidIPv4MappedIPv6Address() {
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"2001:0db8:0000:0000:0000:0000:1428:57ab"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::ffff:1:2:3:4"));
    }

    @Test
    void testValidIPv4MappedIPv6AddressWithLeadingZeros() {
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::ffff:001.002.003.004"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::FFFF:000.000.000.255"));
        Assertions.assertTrue((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::ffff:010.020.030.040"));
    }

    @Test
    void testInvalidIPv4MappedIPv6AddressWithBadOctets() {
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::ffff:256.000.000.000"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::ffff:01.02.03"));
        Assertions.assertFalse((boolean)InetAddressUtils.isIPv4MappedIPv6((CharSequence)"::ffff:0255.000.000.000"));
    }
}

