/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.thread;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.shaded.org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.shaded.org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.shaded.org.apache.ignite.internal.thread.LogUncaughtExceptionHandler;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final boolean daemon;
    private final Thread.UncaughtExceptionHandler exHnd;

    public NamedThreadFactory(String prefix, IgniteLogger log) {
        this(prefix, false, log);
    }

    public NamedThreadFactory(String prefix, boolean daemon, IgniteLogger log) {
        this(prefix, daemon, new LogUncaughtExceptionHandler(log));
    }

    public NamedThreadFactory(String prefix, boolean daemon, Thread.UncaughtExceptionHandler exHnd) {
        this.prefix = Objects.requireNonNull(prefix, "prefix");
        this.daemon = daemon;
        this.exHnd = Objects.requireNonNull(exHnd, "exHnd");
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(this.daemon);
        t.setUncaughtExceptionHandler(this.exHnd);
        t.setName(this.prefix + this.counter.getAndIncrement());
        return t;
    }

    public static String threadPrefix(String nodeName, String poolName) {
        return IgniteThread.threadPrefix(nodeName, poolName);
    }

    public static NamedThreadFactory create(String nodeName, String poolName, IgniteLogger logger) {
        return new NamedThreadFactory(NamedThreadFactory.threadPrefix(nodeName, poolName), logger);
    }

    public static NamedThreadFactory create(String nodeName, String poolName, boolean daemon, IgniteLogger logger) {
        return new NamedThreadFactory(NamedThreadFactory.threadPrefix(nodeName, poolName), daemon, logger);
    }
}

