/*
 * Decompiled with CFR 0.152.
 */
package org.treesitter;

import org.treesitter.AnonymousLanguage;
import org.treesitter.CleanerRunner;
import org.treesitter.TSException;
import org.treesitter.TSLanguage;
import org.treesitter.TSParser;

public class TsLookAheadIterator {
    private long ptr;

    public TsLookAheadIterator(TSLanguage language, int state) {
        this.ptr = TSParser.ts_lookahead_iterator_new(language.getPtr(), state);
        if (this.ptr == 0L) {
            throw new TSException("State is invalid.");
        }
        CleanerRunner.register(this, new TsLookAheadIteratorCleanAction(this.ptr));
    }

    public boolean resetState(int state) {
        return TSParser.ts_lookahead_iterator_reset_state(this.ptr, state);
    }

    public boolean reset(TSLanguage language, int state) {
        return TSParser.ts_lookahead_iterator_reset(this.ptr, language.getPtr(), state);
    }

    public TSLanguage getLanguage() {
        return new AnonymousLanguage(TSParser.ts_lookahead_iterator_language(this.ptr));
    }

    public boolean next() {
        return TSParser.ts_lookahead_iterator_next(this.ptr);
    }

    public int currentSymbol() {
        return TSParser.ts_lookahead_iterator_current_symbol(this.ptr);
    }

    public String currentSymbolName() {
        return TSParser.ts_lookahead_iterator_current_symbol_name(this.ptr);
    }

    protected long getPtr() {
        return this.ptr;
    }

    public static class TsLookAheadIteratorCleanAction
    implements Runnable {
        private long ptr;

        public TsLookAheadIteratorCleanAction(long ptr) {
            this.ptr = ptr;
        }

        @Override
        public void run() {
            TSParser.ts_lookahead_iterator_delete(this.ptr);
        }
    }
}

