/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.raft.MinimumRequiredTimeCollectorService;

public class MinimumRequiredTimeCollectorServiceImpl
implements MinimumRequiredTimeCollectorService {
    private final ConcurrentHashMap<TablePartitionId, Long> partitions = new ConcurrentHashMap();

    @Override
    public void addPartition(TablePartitionId tablePartitionId) {
        this.partitions.put(tablePartitionId, 0L);
    }

    @Override
    public void recordMinActiveTxTimestamp(TablePartitionId tablePartitionId, long timestamp) {
        this.partitions.computeIfPresent(tablePartitionId, (k, v) -> {
            if (v == 0L) {
                return timestamp;
            }
            if (timestamp > v) {
                return timestamp;
            }
            return v;
        });
    }

    @Override
    public void removePartition(TablePartitionId tablePartitionId) {
        this.partitions.remove(tablePartitionId);
    }

    @Override
    public Map<TablePartitionId, Long> minTimestampPerPartition() {
        return Collections.unmodifiableMap(this.partitions);
    }
}

