/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.ZonePartitionKey;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshot;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.PartitionSnapshots;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.PartitionsSnapshots;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.storage.AbortResult;
import org.apache.ignite.internal.storage.AddWriteCommittedResult;
import org.apache.ignite.internal.storage.AddWriteResult;
import org.apache.ignite.internal.storage.CommitResult;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.PartitionTimestampCursor;
import org.apache.ignite.internal.storage.ReadResult;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.gc.GcEntry;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SnapshotAwarePartitionDataStorage
implements PartitionDataStorage {
    private final int tableId;
    private final MvPartitionStorage partitionStorage;
    private final PartitionsSnapshots partitionsSnapshots;
    private final PartitionKey partitionKey;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();

    public SnapshotAwarePartitionDataStorage(int tableId, MvPartitionStorage partitionStorage, PartitionsSnapshots partitionsSnapshots, PartitionKey partitionKey) {
        this.tableId = tableId;
        this.partitionStorage = partitionStorage;
        this.partitionsSnapshots = partitionsSnapshots;
        this.partitionKey = partitionKey;
    }

    public int tableId() {
        return this.tableId;
    }

    public int partitionId() {
        return this.partitionKey.partitionId();
    }

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        return (V)this.partitionStorage.runConsistently(closure);
    }

    public void acquirePartitionSnapshotsReadLock() {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.acquireReadLock();
    }

    public void releasePartitionSnapshotsReadLock() {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        partitionSnapshots.releaseReadLock();
    }

    private PartitionSnapshots getPartitionSnapshots() {
        return this.partitionsSnapshots.partitionSnapshots(this.partitionKey);
    }

    public CompletableFuture<Void> flush(boolean trigger) {
        return this.partitionStorage.flush(trigger);
    }

    public long lastAppliedIndex() {
        return this.partitionStorage.lastAppliedIndex();
    }

    public long lastAppliedTerm() {
        return this.partitionStorage.lastAppliedTerm();
    }

    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.partitionStorage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    public void committedGroupConfiguration(RaftGroupConfiguration config) {
        this.partitionStorage.committedGroupConfiguration(this.raftGroupConfigurationConverter.toBytes(config));
    }

    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration() {
        return this.raftGroupConfigurationConverter.fromBytes(this.partitionStorage.committedGroupConfiguration());
    }

    public AddWriteResult addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableOrZoneId, int commitPartitionId) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.addWrite(rowId, row, txId, commitTableOrZoneId, commitPartitionId);
    }

    public AddWriteCommittedResult addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.addWriteCommitted(rowId, row, commitTimestamp);
    }

    public AbortResult abortWrite(RowId rowId, UUID txId) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.abortWrite(rowId, txId);
    }

    public CommitResult commitWrite(RowId rowId, HybridTimestamp timestamp, UUID txId) throws StorageException {
        this.handleSnapshotInterference(rowId);
        return this.partitionStorage.commitWrite(rowId, timestamp, txId);
    }

    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        return this.partitionStorage.scanVersions(rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSnapshotInterference(RowId rowId) {
        PartitionSnapshots partitionSnapshots = this.getPartitionSnapshots();
        for (OutgoingSnapshot snapshot : partitionSnapshots.ongoingSnapshots()) {
            snapshot.acquireMvLock();
            try {
                if (snapshot.alreadyPassedOrIrrelevant(this.tableId, rowId) || !snapshot.addRowIdToSkip(rowId)) continue;
                snapshot.enqueueForSending(this.tableId, rowId);
            }
            finally {
                snapshot.releaseMvLock();
            }
        }
    }

    public void close() {
        if (this.partitionKey instanceof ZonePartitionKey) {
            return;
        }
        this.partitionsSnapshots.cleanupOutgoingSnapshots(this.partitionKey);
    }

    @TestOnly
    public MvPartitionStorage getStorage() {
        return this.partitionStorage;
    }

    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        return this.partitionStorage.scan(timestamp);
    }

    @Nullable
    public GcEntry peek(HybridTimestamp lowWatermark) {
        return this.partitionStorage.peek(lowWatermark);
    }

    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        return this.partitionStorage.vacuum(entry);
    }

    public void updateLease(LeaseInfo leaseInfo) {
        this.partitionStorage.updateLease(leaseInfo);
    }

    @Nullable
    public LeaseInfo leaseInfo() {
        return this.partitionStorage.leaseInfo();
    }
}

