/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.prompt;

import jakarta.inject.Singleton;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.cli.core.repl.Session;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.repl.prompt.PromptProvider;
import org.apache.ignite3.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite3.internal.cli.event.ConnectionEventListener;

@Singleton
public class ReplPromptProvider
implements PromptProvider,
ConnectionEventListener {
    private final Session session;
    private final AtomicBoolean connected = new AtomicBoolean(true);

    public ReplPromptProvider(Session session) {
        this.session = session;
    }

    @Override
    public String getPrompt() {
        String postfix = "> ";
        SessionInfo sessionInfo = this.session.info();
        if (sessionInfo != null) {
            String username = sessionInfo.username();
            AnsiStringSupport.Color color = this.connected.get() ? AnsiStringSupport.Color.GREEN : AnsiStringSupport.Color.YELLOW;
            return AnsiStringSupport.ansi(AnsiStringSupport.fg(color).mark("[" + (String)(username != null ? username + ":" : "") + sessionInfo.nodeName() + "]")) + postfix;
        }
        return AnsiStringSupport.ansi(AnsiStringSupport.fg(AnsiStringSupport.Color.RED).mark("[disconnected]")) + postfix;
    }

    @Override
    public void onConnectionLost() {
        this.connected.getAndSet(false);
    }

    @Override
    public void onConnectionRestored() {
        this.connected.getAndSet(true);
    }
}

