/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.distributionzones;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite3.internal.distributionzones.Node;
import org.apache.ignite3.internal.distributionzones.NodeSerializer;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

public class NodeWithAttributesSerializer
extends VersionedSerializer<NodeWithAttributes> {
    public static final NodeWithAttributesSerializer INSTANCE = new NodeWithAttributesSerializer();
    private final NodeSerializer nodeSerializer = NodeSerializer.INSTANCE;

    @Override
    protected void writeExternalData(NodeWithAttributes node, IgniteDataOutput out) throws IOException {
        this.nodeSerializer.writeExternal(node.node(), out);
        out.writeVarInt(node.userAttributes().size());
        for (Map.Entry<String, String> attrEntry : node.userAttributes().entrySet()) {
            out.writeUTF(attrEntry.getKey());
            out.writeUTF(attrEntry.getValue());
        }
        out.writeVarInt(node.storageProfiles().size());
        for (String profile : node.storageProfiles()) {
            out.writeUTF(profile);
        }
    }

    @Override
    protected NodeWithAttributes readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        Node node = (Node)this.nodeSerializer.readExternal(in);
        Map<String, String> userAttributes = NodeWithAttributesSerializer.readUserAttributes(in);
        List<String> storageProfiles = NodeWithAttributesSerializer.readStorageProfiles(in);
        return new NodeWithAttributes(node.nodeName(), node.nodeId(), userAttributes, storageProfiles);
    }

    private static Map<String, String> readUserAttributes(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        HashMap<String, String> attrs = new HashMap<String, String>(IgniteUtils.capacity(length));
        for (int i = 0; i < length; ++i) {
            attrs.put(in.readUTF(), in.readUTF());
        }
        return attrs;
    }

    private static List<String> readStorageProfiles(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        ArrayList<String> storageProfiles = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            storageProfiles.add(in.readUTF());
        }
        return storageProfiles;
    }
}

