/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.retain.server.scheduler;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.bifromq.retain.rpc.proto.BatchRetainRequest;
import org.apache.bifromq.retain.rpc.proto.RetainMessage;
import org.apache.bifromq.retain.rpc.proto.RetainParam;
import org.apache.bifromq.retain.rpc.proto.RetainRequest;

class BatchRetainCallHelper {
    BatchRetainCallHelper() {
    }

    static BatchRetainRequest makeBatch(Iterator<RetainRequest> retainRequestIterator) {
        HashMap<String, RetainParam.Builder> retainMsgPackBuilders = new HashMap<String, RetainParam.Builder>(128);
        retainRequestIterator.forEachRemaining(request -> retainMsgPackBuilders.computeIfAbsent(request.getPublisher().getTenantId(), k -> RetainParam.newBuilder()).putTopicMessages(request.getTopic(), RetainMessage.newBuilder().setMessage(request.getMessage().toBuilder().setIsRetained(true).build()).setPublisher(request.getPublisher()).build()));
        long reqId = System.nanoTime();
        BatchRetainRequest.Builder reqBuilder = BatchRetainRequest.newBuilder().setReqId(reqId);
        retainMsgPackBuilders.forEach((tenantId, retainMsgPackBuilder) -> reqBuilder.putParams(tenantId, retainMsgPackBuilder.build()));
        return reqBuilder.build();
    }
}

